# - Try to find the Polyscope library
# Once done this will define
#
#  POLYSCOPE_FOUND - system has Polyscope
#  POLYSCOPE_INCLUDE_DIR - the Polyscope include directory

if(POLYSCOPE_FOUND)
    return()
endif(POLYSCOPE_FOUND)

find_path(POLYSCOPE_INCLUDE_DIR polyscope/polyscope.h
    HINTS
        ${POLYSCOPE_DIR}
    ENV POLYSCOPE_DIR
    PATHS
        ${CMAKE_SOURCE_DIR}/../..
        ${CMAKE_SOURCE_DIR}/..
        ${CMAKE_SOURCE_DIR}
        ${CMAKE_SOURCE_DIR}/polyscope
        ${CMAKE_SOURCE_DIR}/../polyscope
        ${CMAKE_SOURCE_DIR}/../../polyscope
    PATH_SUFFIXES include
)

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(Polyscope
    FOUND_VAR POLYSCOPE_FOUND
    REQUIRED_VARS
        POLYSCOPE_INCLUDE_DIR
)

if(POLYSCOPE_FOUND)
    if (NOT DEFINED POLYSCOPE_DIR)
        set(POLYSCOPE_DIR "${POLYSCOPE_INCLUDE_DIR}/..")
    endif()
    add_subdirectory(${POLYSCOPE_DIR} "${CMAKE_CURRENT_BINARY_DIR}/polyscope")
endif(POLYSCOPE_FOUND)
