<?xml version="1.1" encoding="utf-8"?>
<!--
Celle là fait l'applatissement du musicXML au niveau de la mesure.
tous les tags <measure num="oo">  </measure> sont transformés en <measurebar num="oo"/>
-->

<!DOCTYPE xsl:stylesheet SYSTEM "mmlents/windob.dtd">
<xsl:stylesheet version="2.0"
		xmlns:xs='http://www.w3.org/2001/XMLSchema'
		xmlns:xsl='http://www.w3.org/1999/XSL/Transform'
		xmlns:functx='http://www.functx.com' 
		xmlns:fn='http://www.w3.org/2005/xpath-functions'
		xmlns:nat='http://natbraille.free.fr/xsl'>
  <xsl:output method="xml" indent="yes" />
  <xsl:include href="musique_outils.xsl" /> 
  <xsl:include href="musicxml2.xsl" /> 
  <xsl:include href="functions/functx-1.1alpha.xsl" />

  <xsl:variable name="mdbg" select="fn:false()" />
  <xsl:strip-space elements="*" />


  <!-- 
       Score-partwise 
  -->
  <xsl:template match="score-partwise">     
    <xsl:variable name="flattened" >
      <xsl:element name="flat-score-partwise"  >
	<xsl:copy-of copy-namespaces="no" select="work" />
	<xsl:element name="score-direction">
	  <xsl:value-of select="./part/measure[1]/direction/direction-type/words"/>
	</xsl:element>
	<xsl:apply-templates mode="flatten"/>
      </xsl:element>
    </xsl:variable>
    <xsl:apply-templates select="$flattened" />
  </xsl:template>

  <!-- 
       Part 
  -->
  <xsl:template match="part" mode="flatten" >    
    
    <!-- part name -->
    <xsl:element name = "part" >
      <xsl:element name = "name" >
	<xsl:call-template name="getScorePartNameById">    
	  <xsl:with-param name="id" select="@id" />
	</xsl:call-template>
      </xsl:element>
      
      <!-- Measures -->
      
      <xsl:for-each select="measure">
	<xsl:message>
	  <xsl:element name="{local-name(.)}">
	    <xsl:copy-of select="@*"/>

	    <!-- add end and star times of elements -->
	    <xsl:variable name="pass1"> 	         	
	      <xsl:call-template name="add-time-boundaries"/>
	    </xsl:variable>

	    <!-- partial measure grouping  -->
	    <xsl:variable name="partial-measures">
	      <xsl:call-template name="group-partial-measure">
		<xsl:with-param name="p" select="$pass1"/>
	      </xsl:call-template>
	    </xsl:variable>

	    <!-- chord grouping  -->
	    <xsl:variable name="chords">
	      <xsl:for-each select="$partial-measures/*">
		<xsl:element name="{local-name(.)}">
		  <xsl:copy-of select="@*"/>
		  <xsl:call-template name="group-chord" >
		    <xsl:with-param name="p" select="./*"/>
		  </xsl:call-template>
		</xsl:element>
	      </xsl:for-each>
	    </xsl:variable>

	    <!-- voice grouping -->
	    <xsl:variable name="voices">
	      <xsl:for-each select="$chords/*">
		<xsl:element name="{local-name(.)}">
		  <xsl:copy-of select="@*"/>
		  <xsl:call-template name="group-voices" >		    
		    <xsl:with-param name="p" select="./*"/>
		  </xsl:call-template>
		</xsl:element> 
	      </xsl:for-each>
	    </xsl:variable>
	    <!--
		<xsl:copy-of select="$voices"/>
	    -->
	    
	    <!-- partial measures merging -->
	    <!--
		<xsl:variable name="voicess">
		<xsl:for-each select="$voices/">
		<xsl:element name="{local-name(.)}">
		<xsl:copy-of select="@*"/>
		<xsl:call-template name="merge-partial-measures" >		    
		<xsl:with-param name="p" select="."/>
		</xsl:call-template>
		</xsl:element> 
		</xsl:for-each>
		</xsl:variable>
	    -->
	    <!--
		<xsl:copy-of select="$voicess"/>
	    -->
	    <xsl:call-template name="merge-partial-measures" >		    
	      <xsl:with-param name="p" select="$voices"/>
	      <xsl:with-param name="n" select="1"/>
	    </xsl:call-template>


	  </xsl:element>
	</xsl:message>

	<xsl:element name = "measure_start"  inherit-namespaces="no">
	  <xsl:attribute name="number" select="./@number"/>  
	</xsl:element>	
	<xsl:copy-of copy-namespaces="no" select="./*[self::name|self::attributes|self::note|self::direction]" />
	<xsl:element name = "measure_stop" >
	  <xsl:attribute name="bar-style" select="./barline/bar-style" />
	</xsl:element>	
      </xsl:for-each>
    </xsl:element>
  </xsl:template>

  <!-- 
       don't use  work|identification|part-list
  -->  
  <xsl:template match="work|identification|part-list" mode="flatten">
  </xsl:template>


  <!-- 
       gets part name by id  
  -->
  <xsl:template name="getScorePartNameById">
    <xsl:param name="id" as="xs:string"/>
    <xsl:value-of select="//score-partwise/part-list/score-part[@id=$id]/part-name"/>
  </xsl:template>
  
  <!--
      ========================================================================
  -->
  <!-- 
       adds a @start-time and @end-time as attribute of <note> 
  -->
  <xsl:template name="add-time-boundaries">
    <xsl:element name="{local-name(.)}" >
      <xsl:copy-of select="@*"/>
      <xsl:for-each select="note|attributes|direction">
	<xsl:variable name="tDuration" 
		      select="if (number(./duration)) then (number(./duration)) else (0)"/>
	<xsl:variable name="tChordedNotes"
		      select="sum(preceding-sibling::note[./following-sibling::note[1]/chord]/duration)"/>
	<xsl:variable name="tNotes" 
		      select="sum(preceding-sibling::note/duration)"/> 
	<xsl:variable name="tBackups"
		      select="sum(preceding-sibling::backup)"/> 
	<xsl:variable name="tForwards"
		      select="sum(preceding-sibling::forward)"/> 
	<xsl:element name="{local-name(.)}" >
	  <xsl:copy-of select="@*"/>
	  <xsl:attribute name="start-time">
	    <xsl:value-of select="($tNotes + $tForwards -$tBackups - $tChordedNotes)" />
	  </xsl:attribute>
	  <xsl:attribute name="end-time">
	    <xsl:value-of select="($tNotes + $tForwards -$tBackups - $tChordedNotes + $tDuration)" />
	  </xsl:attribute>
	  <xsl:copy-of copy-namespaces="no" select="./*"/>
	</xsl:element>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>

  <!--  
       group simultaneous start and stop nodes under a 
       *partial-measure* parent
  -->
  <xsl:template name="group-partial-measure">
    <xsl:param name="p" as="node()*" />
    
    <!-- grep sequence of starts of partial measure cuts -->
    <xsl:variable name="possible-starts">
      <xsl:for-each select="$p/measure/note">	
	<xsl:variable name="start" select="number(./@start-time)" />
	<xsl:variable name="fsCut" select="following-sibling::note
					   [number(./@start-time ) &lt; number($start)]
					   [number(./@end-time) &gt; number($start)]"/>
	<xsl:variable name="psCut" select="preceding-sibling::note
					   [number(./@start-time) &lt; number($start)]
					   [number(./@end-time) &gt; number($start)]"/>
	<xsl:if test="not($fsCut) and not($psCut)">
	  <xsl:element name="time">    
	    <xsl:value-of select="$start" />
	  </xsl:element>
	</xsl:if>
      </xsl:for-each>
      <xsl:element name="time">    
	<xsl:value-of select="fn:max($p/measure/*/@end-time)" />
      </xsl:element>
    </xsl:variable>

    <!-- sort and unique start times sequence -->
    <xsl:variable name="distinct-starts">
      <xsl:copy-of select="functx:sort-as-numeric(functx:distinct-deep($possible-starts//time))"/>
    </xsl:variable>
    
    
    <!-- group notes under new parent partial measures -->
    <xsl:for-each select="$distinct-starts/time[not(position() = last())]">
      <xsl:variable name="start-time"><xsl:value-of select="."/></xsl:variable>
      <xsl:variable name="end-time" ><xsl:value-of select="following-sibling::time[1]"/></xsl:variable>
      <xsl:element name="partial-measure">
	<xsl:attribute name="start-time" select="$start-time"/>
	<xsl:attribute name="end-time" select="$end-time"/>	
	<xsl:for-each select="$p/measure/*[(number(./@start-time) &gt;= number($start-time)) and (number(./@end-time)&lt;= number($end-time))]">
	  <xsl:copy-of select="."/>
	</xsl:for-each>
      </xsl:element>
    </xsl:for-each>
  </xsl:template>


  <!-- 
       group *notes* with same start and entime
       within a *chord*
  -->
  <xsl:template name="group-chord">
    <xsl:param name="p" as="node()*" /> 
    <xsl:for-each select="$p">
      <xsl:variable name="start" select="@start-time" />
      <xsl:variable name="stop" select="@end-time" />
      <xsl:variable name="dejavu" select="preceding-sibling::note
					  [self::note/@start-time=$start]
					  [self::note/@end-time=$stop]"/>
      <xsl:if test="not($dejavu)">
	<xsl:choose>
	  <xsl:when test="local-name(.) = 'note'">
	    <xsl:element name="chord">
	      <xsl:variable name="chordId" select="generate-id()"/>
	      <xsl:copy-of select="@start-time"/>
	      <xsl:copy-of select="@end-time"/>
	      <xsl:attribute name="id">
		<xsl:value-of select="$chordId" />
	      </xsl:attribute>
	      <xsl:copy-of select="."/>
	      <xsl:for-each select="following-sibling::note
				    [self::note/@start-time=$start]
				    [self::note/@end-time=$stop]">
		<xsl:element name="{local-name(.)}">
		  <xsl:attribute name="chord-id">
		    <xsl:value-of select="$chordId" />
		  </xsl:attribute>
		  <xsl:copy-of select="./*"/>
		</xsl:element>
		
	      </xsl:for-each>
	    </xsl:element>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:copy-of select="."/>
	  </xsl:otherwise>
	</xsl:choose>
      </xsl:if>
    </xsl:for-each>
  </xsl:template>



  <!-- 
       Voice grouping
       ==============
  -->
  <!--
      evaluate possible followers of a *chord* amongst
      a sequence of *chords*
  -->
  <xsl:function name="nat:next-chord-evaluator">
    <xsl:param name="c" as="node()" />
    <xsl:param name="n" as="node()*" />
    <xsl:for-each select="$n">
      <xsl:variable name="va" select="$c/note/voice/text()"/>
      <xsl:variable name="vb" select="./note/voice/text()"/>
      <xsl:variable name="v_started" 
		    select="fn:count(functx:value-except(fn:distinct-values($vb),fn:distinct-values($va)))" />
      <xsl:variable name="v_stopped" 
		    select="fn:count(functx:value-except(fn:distinct-values($va),fn:distinct-values($vb)))" />
      <xsl:variable name="v_keeped" 
		    select="fn:count(functx:value-intersect(fn:distinct-values($va),fn:distinct-values($vb)))" />
      <xsl:variable name="sa" select="$c/note/staff/text()"/>
      <xsl:variable name="sb" select="./note/staff/text()"/>
      <xsl:variable name="s_started" 
		    select="fn:count(functx:value-except(fn:distinct-values($sb),fn:distinct-values($sa)))" />
      <xsl:variable name="s_stopped" 
		    select="fn:count(functx:value-except(fn:distinct-values($sa),fn:distinct-values($sb)))" />
      <xsl:variable name="s_keeped" 
		    select="fn:count(functx:value-intersect(fn:distinct-values($sa),fn:distinct-values($sb)))" />
      <xsl:element name="item">
	<xsl:attribute name="pitchA" select="$c/note/pitch" />
	<xsl:attribute name="pitchB" select="./note/pitch" />


	<xsl:attribute name="v_started" select="$v_started" />
	<xsl:attribute name="v_stopped" select="$v_stopped" />
	<xsl:attribute name="v_keeped" select="$v_keeped" />
	<xsl:attribute name="s_started" select="$s_started" />
	<xsl:attribute name="s_stopped" select="$s_stopped" />
	<xsl:attribute name="s_keeped" select="$s_keeped" />
	<xsl:attribute name="score" select="(if ($va and $vb)
					    then ($v_keeped - $v_stopped - $v_started)
					    else (if ($va) then (1) else (0)))
					    +
					    (if ($sa and $sb)
					    then ($s_keeped - $s_stopped - $s_started)
					    else (if ($sa) then (1) else (0)))
					    
					    "/>
	<xsl:attribute name="id-ref" select="@id"/>
	
      </xsl:element>
    </xsl:for-each>
  </xsl:function>
  

  <!--
      traverse a sequence of chords to associate
      voices
  -->
  <xsl:function name="nat:get-next-chord-in-voice" >
    <xsl:param name="p" as="node()*" />
    <xsl:copy-of select="$p[1]"/>
    <xsl:if test="$p[not(position()=1)]">
      <xsl:variable name="cur-acc-end" select="$p[1]/@end-time"/>
      
      <!-- evaluate candidates -->
      <xsl:variable name="possible-next" select="$p[not(position()=1)][$cur-acc-end = @start-time]"/>
      <xsl:variable name="scores">
	<xsl:copy-of select="nat:next-chord-evaluator($p[1],$possible-next)"/>
      </xsl:variable>    
      
      <!-- winner id -->
      <xsl:variable name="next-id">
	<xsl:value-of select="$scores/item[max($scores/item/@score) = @score][position()=1]/@id-ref"/>
      </xsl:variable>

      <!-- no follower ? put *voice-change/* -->    
      <xsl:if test="$next-id = ''">
	<xsl:element name="voice-change" />
      </xsl:if>

      <!-- iterate -->
      <xsl:variable name="passit">
	<xsl:copy-of select="$p[@id = $next-id]"/>
	<xsl:copy-of select="$p[not(position()=1)][not(@id = $next-id)]" />
      </xsl:variable>

      <xsl:copy-of select="nat:get-next-chord-in-voice($passit/*)"/>

    </xsl:if>
  </xsl:function>
  

  <!--
      group sequences separated by voice-change element under voice element
  -->
  <xsl:function name="nat:make-voice-parent-for-voice-changes-in-partial-measure">
    <xsl:param name="p" as="node()*" />    

    <xsl:element name="voice">
      <xsl:copy-of select="$p[not(preceding-sibling::voice-change)][not(self::voice-change)]"/>
    </xsl:element>
    <xsl:variable name="op">
      <xsl:copy-of select="$p[preceding-sibling::voice-change]"/>
    </xsl:variable>
    <xsl:copy-of select="if ($op/*) 
			 then (nat:make-voice-parent-for-voice-changes-in-partial-measure($op/*))
			 else ()"/> 
    
  </xsl:function>


  <!-- 
       voice-grouping inside a partial-measure
  -->
  <xsl:template name="group-voices">
    <xsl:param name="p" as="node()*" /> 
    <xsl:variable name="voices">
      <xsl:copy-of select="nat:get-next-chord-in-voice(./*)"/>
    </xsl:variable>
    <xsl:copy-of select="nat:make-voice-parent-for-voice-changes-in-partial-measure($voices/*)"/>
  </xsl:template>

  <!-- 
       partial measure voices references associator 
       from scores 
       
       p is
       
       <a>
       <source id-ref="x">
       <item id-ref="y" score"z"/>
       </a>
       <a>
       ...
       </a>
       
       returns *association* elements 
       with source-id-ref and dest-id-ref attributes beeing 
       references to chord ids
  -->
  <xsl:function name="nat:associator">
    <xsl:param name="p" as="node()*" />

    <!-- get first best association  -->
    <xsl:variable name="bestScore" select="max($p//@score)"/>
    <xsl:variable name="oneHavingThisScore" select="$p[./item/@score=$bestScore][1]"/>
    <xsl:variable name="itsSourceIdRef">
      <xsl:value-of select="$oneHavingThisScore/source/@id-ref"/>
    </xsl:variable>
    <xsl:variable name="itsDestIdRef">
      <xsl:value-of select="$oneHavingThisScore/item/@id-ref"/>
    </xsl:variable>

    <!-- write it -->
    <xsl:element name="association">
      <xsl:attribute name="source-id-ref" select="$itsSourceIdRef"/>
      <xsl:attribute name="dest-id-ref" select="$itsDestIdRef"/>
    </xsl:element>

    <!-- iterate for all other possible associations in tail -->
    <xsl:variable name="tail">
      <xsl:copy-of select="$p[not(./source/@id-ref = $itsSourceIdRef)]
			   [not(./item/@id-ref = $itsDestIdRef)]"/>
    </xsl:variable>
    <xsl:copy-of select="if ($tail/*) then (nat:associator($tail/*)) else ()"/>
  </xsl:function>


  
  
  <xsl:template name="merge-partial-measures">
    <xsl:param name="p" as="node()*" />
    <xsl:param name="n" />


    <xsl:variable name="p1" select="$p/partial-measure[1]"/>
    <xsl:variable name="p2" select="$p/partial-measure[2]"/>
    <!-- <xsl:message> -->
    <!--   <ENTREE> -->
    <!-- 	<xsl:attribute name="iteration" select="$n"/> -->
    <!-- 	   <xsl:copy-of select="$p" /> -->
    <!-- 	 <P1>  -->
    <!-- 	   <xsl:copy-of select="$p1" /> -->
    <!-- 	 </P1> -->
    <!-- 	 <P2> -->
    <!-- 	   <xsl:copy-of select="$p2" /> -->
    <!-- 	 </P2> -->
    <!--   </ENTREE> -->
    <!-- </xsl:message> -->


    <xsl:variable name="merged12">
      <xsl:if test="(count($p1/voice) = count($p2/voice)) and (not(count($p/*) = 0))">
	
	<!-- determine partial measures voice associations scores -->
	<xsl:variable name="scores">
	  <xsl:for-each select="$p1/voice"> 
	    <xsl:variable name="lastchord" select="./chord[last()]"/>
	    <xsl:variable name="source">
	      <xsl:element name="source">
		<xsl:attribute name="id-ref" select="$lastchord/@id"/>
	      </xsl:element>
	    </xsl:variable>
	    <xsl:for-each select="$p2/voice"> 
	      <xsl:element name="possible-association">
		<xsl:copy-of select="$source"/>
		<xsl:variable name="nextchord" select="./chord[1]"/>
		<xsl:copy-of select="nat:next-chord-evaluator($lastchord,$nextchord)"/>
	      </xsl:element>
	    </xsl:for-each>
	  </xsl:for-each>
	</xsl:variable> 
	<!--  -->    
	<xsl:variable name="associations" select="nat:associator($scores/*)"/>

	<!-- new *partial-mesure* remplacement for 1 and 2 -->
	<xsl:element name="partial-measure">
	  <xsl:attribute name="start-time" select="$p1/@start-time" />
	  <xsl:attribute name="end-time" select="$p2/@end-time" />	  
	  <xsl:for-each select="$associations" >
	    <xsl:element name="voice">
	      <xsl:variable name="source-id-ref">
		<xsl:value-of select="@source-id-ref" />
	      </xsl:variable>
	      <xsl:variable name="dest-id-ref">
		<xsl:value-of select="@dest-id-ref" />
	      </xsl:variable>
	      <xsl:copy-of select="$p1/voice[./chord/@id = $source-id-ref]/*"/>
<!--
    <xsl:comment>
    <id1><xsl:copy-of select="$source-id-ref"/></id1>
    <id2><xsl:value-of select="$dest-id-ref"/></id2>
    </xsl:comment>
-->
	      <xsl:copy-of select="$p2/voice[./chord/@id = $dest-id-ref]/*"/>
	    </xsl:element>
	  </xsl:for-each>
	</xsl:element>
      </xsl:if>
    </xsl:variable>
    <xsl:variable name="haveMerged" select="count($merged12/*)>0" />

    <!-- 1 and 2 have not been merged ;	 write 1 and pass 2-->
    <!-- <xsl:message> -->
    <!--   <voilacequejaimerfe> -->
    <!-- 	<xsl:attribute name="iteration" select="$n"/> -->
    <!-- 	<xsl:copy-of select="$merged12" /> -->
    <!--   </voilacequejaimerfe> -->
    <!--   <merege> -->
    <!-- 	<xsl:value-of select="count($merged12/*)>0"/> -->
    <!--   </merege> -->
    <!-- </xsl:message> -->

    <xsl:if test="not($haveMerged)">     
	<xsl:copy-of select="$p/partial-measure[1]" />
    </xsl:if>

    <xsl:variable name="tail">      
      <xsl:choose>
	<xsl:when test="$haveMerged">
	  <xsl:copy-of select="$merged12" />
	  <xsl:copy-of select="$p/partial-measure[position()>2]"/>
	</xsl:when>
	<xsl:otherwise>
	  <xsl:copy-of select="$p/partial-measure[position()>1]" />
	</xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <!-- <xsl:message> -->
    <!--   <regardemaqueue> -->
    <!-- 	<xsl:attribute name="iteration" select="$n"/> -->
    <!-- 	<xsl:copy-of select="$tail" /> -->
    <!--   </regardemaqueue> -->
    <!-- </xsl:message> -->

    <xsl:if test="count($tail/*) &gt; 0">
      <xsl:call-template name="merge-partial-measures">
	<xsl:with-param name="p" select="$tail"/>
	<xsl:with-param name="n" select="$n+1"/>
      </xsl:call-template>
    </xsl:if>
    

  </xsl:template>


  <!-- 
       Tools
       ==============
  -->


  <!--
      Pitch to midi note number conversion
  -->
  <xsl:function name="nat:pitch-to-midi" xs:memo-function="yes" >
    <xsl:param name="p" as="node()" />
    <xsl:copy-of select="$p"/>    
    <xsl:variable name="note" select="functx:index-of-string-first('C.D.EF.G.A.B',$p/step)-1" />
    <xsl:variable name="alter" select="if ($p/alter) then ($p/alter/text()) else (0)" />
    <xsl:variable name="octave" select="($p/octave +1)* 12" />
    <xsl:value-of select="$note + $alter + $octave"/>
  </xsl:function>


  <xsl:function name="nat:concise-presenter">
    <xsl:param name="p" as="node()*" /> 
    <!-- <xsl:for-each select="$voice/*"> -->
    <!--   <xsl:if test="local-name(.) = 'chord'"> -->
    <!-- 	<xsl:comment> -->
    <!-- 	  <xsl:value-of select = "' { '"/> -->
    <!-- 	  <xsl:for-each select="note"> -->
    <!-- 	    <xsl:value-of select="pitch"/> -->
    <!-- 	    <xsl:value-of select="if (rest) then ('R') else ('')"/> -->
    <!-- 	    <xsl:value-of select="concat('(',type,(if (dot) then ('.') else ('')),duration,')')"/> -->
    <!-- 	    <xsl:value-of select="concat('(s',staff,' v',voice,')')"/> -->
    <!-- 	    <xsl:value-of select="concat('(',@start-time,'-',@end-time,')')"/> -->
    <!-- 	    <xsl:value-of select="' '"/> -->
    <!-- 	  </xsl:for-each> -->
    <!-- 	  <xsl:value-of select = "' } '"/> -->
    <!-- 	</xsl:comment> -->
    <!--   </xsl:if> -->
    <!--   <xsl:if test="local-name(.) = 'attributes'"> -->
    <!-- 	<xsl:comment> -->
    <!-- 	  <xsl:value-of select="."/> -->
    <!-- 	</xsl:comment> -->
    <!--   </xsl:if> -->
    <!--   <xsl:if test="local-name(.) = 'voice-change'"> -->
    <!-- 	<xsl:comment> -->
    <!-- 	  <xsl:value-of select="'||'"/> -->
    <!-- 	</xsl:comment> -->
    <!--   </xsl:if> -->
    <!--   <xsl:for-each select="voice-change"> -->
    <!-- 	<xsl:copy-of select="."/> -->
    <!--   </xsl:for-each> -->
    <!-- </xsl:for-each> -->

  </xsl:function>

</xsl:stylesheet>
