/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.xqj;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItemAccessor;
import javax.xml.xquery.XQItemType;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.dom.DOMObjectModel;
import net2.sf.saxon.dom.NodeOverNodeInfo;
import net2.sf.saxon.event.Builder;
import net2.sf.saxon.event.PipelineConfiguration;
import net2.sf.saxon.event.Sender;
import net2.sf.saxon.evpull.PullEventSource;
import net2.sf.saxon.evpull.StaxToEventBridge;
import net2.sf.saxon.expr.EarlyEvaluationContext;
import net2.sf.saxon.expr.JPConverter;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.tinytree.TinyBuilder;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.AtomicType;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ExternalObjectType;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.Base64BinaryValue;
import net2.sf.saxon.value.BigIntegerValue;
import net2.sf.saxon.value.BooleanValue;
import net2.sf.saxon.value.CalendarValue;
import net2.sf.saxon.value.DateTimeValue;
import net2.sf.saxon.value.DateValue;
import net2.sf.saxon.value.DecimalValue;
import net2.sf.saxon.value.DoubleValue;
import net2.sf.saxon.value.DurationValue;
import net2.sf.saxon.value.FloatValue;
import net2.sf.saxon.value.GDayValue;
import net2.sf.saxon.value.GMonthDayValue;
import net2.sf.saxon.value.GMonthValue;
import net2.sf.saxon.value.GYearMonthValue;
import net2.sf.saxon.value.GYearValue;
import net2.sf.saxon.value.HexBinaryValue;
import net2.sf.saxon.value.Int64Value;
import net2.sf.saxon.value.ObjectValue;
import net2.sf.saxon.value.QNameValue;
import net2.sf.saxon.value.QualifiedNameValue;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.TimeValue;
import net2.sf.saxon.value.Value;
import net2.sf.saxon.xqj.ObjectConverter;
import net2.sf.saxon.xqj.SaxonDuration;
import net2.sf.saxon.xqj.SaxonXMLGregorianCalendar;
import net2.sf.saxon.xqj.SaxonXQDataFactory;
import net2.sf.saxon.xqj.SaxonXQItemAccessor;
import net2.sf.saxon.xqj.SaxonXQItemType;
import org.w3c.dom.Node;

public class StandardObjectConverter
implements ObjectConverter {
    SaxonXQDataFactory dataFactory;
    Configuration config;

    public StandardObjectConverter(SaxonXQDataFactory factory) {
        this.dataFactory = factory;
        this.config = factory.getConfiguration();
    }

    @Override
    public Object toObject(XQItemAccessor xqItemAccessor) throws XQException {
        Item item = ((SaxonXQItemAccessor)xqItemAccessor).getSaxonItem();
        if (item instanceof AtomicValue) {
            AtomicValue p = (AtomicValue)item;
            int t = p.getItemType(this.config.getTypeHierarchy()).getPrimitiveType();
            switch (t) {
                case 529: {
                    return p.getStringValue();
                }
                case 528: {
                    return ((Base64BinaryValue)p).getBinaryValue();
                }
                case 514: {
                    return ((BooleanValue)p).getBooleanValue();
                }
                case 521: {
                    return new SaxonXMLGregorianCalendar((CalendarValue)p);
                }
                case 519: {
                    return new SaxonXMLGregorianCalendar((CalendarValue)p);
                }
                case 515: {
                    return ((DecimalValue)p).getDecimalValue();
                }
                case 517: {
                    return new Double(((DoubleValue)p).getDoubleValue());
                }
                case 518: {
                    return new SaxonDuration((DurationValue)p);
                }
                case 516: {
                    return new Float(((FloatValue)p).getFloatValue());
                }
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: {
                    return new SaxonXMLGregorianCalendar((CalendarValue)p);
                }
                case 527: {
                    return ((HexBinaryValue)p).getBinaryValue();
                }
                case 532: {
                    if (p instanceof BigIntegerValue) {
                        return ((BigIntegerValue)p).asBigInteger();
                    }
                    int sub = ((AtomicType)p.getItemType(null)).getFingerprint();
                    switch (sub) {
                        case 532: 
                        case 533: 
                        case 534: 
                        case 539: 
                        case 540: 
                        case 541: {
                            return BigInteger.valueOf(((Int64Value)p).longValue());
                        }
                        case 538: {
                            return new Byte((byte)((Int64Value)p).longValue());
                        }
                        case 536: 
                        case 543: {
                            return new Integer((int)((Int64Value)p).longValue());
                        }
                        case 535: 
                        case 542: {
                            return new Long(((Int64Value)p).longValue());
                        }
                        case 537: 
                        case 544: {
                            return new Short((short)((Int64Value)p).longValue());
                        }
                    }
                    throw new XQException("Unrecognized integer subtype " + sub);
                }
                case 530: {
                    return ((QualifiedNameValue)p).toJaxpQName();
                }
                case 513: 
                case 631: {
                    return p.getStringValue();
                }
                case 520: {
                    return new SaxonXMLGregorianCalendar((CalendarValue)p);
                }
                case 634: {
                    return new SaxonDuration((DurationValue)p);
                }
                case 633: {
                    return new SaxonDuration((DurationValue)p);
                }
            }
            throw new XQException("unsupported type");
        }
        return NodeOverNodeInfo.wrap((NodeInfo)item);
    }

    @Override
    public Item convertToItem(Object value) throws XQException {
        try {
            if (value instanceof Boolean) {
                return BooleanValue.get((Boolean)value);
            }
            if (value instanceof byte[]) {
                return new HexBinaryValue((byte[])value);
            }
            if (value instanceof Byte) {
                return new Int64Value(((Byte)value).byteValue(), BuiltInAtomicType.BYTE, false);
            }
            if (value instanceof Float) {
                return new FloatValue(((Float)value).floatValue());
            }
            if (value instanceof Double) {
                return new DoubleValue((Double)value);
            }
            if (value instanceof Integer) {
                return new Int64Value(((Integer)value).intValue(), BuiltInAtomicType.INT, false);
            }
            if (value instanceof Long) {
                return new Int64Value((Long)value, BuiltInAtomicType.LONG, false);
            }
            if (value instanceof Short) {
                return new Int64Value(((Short)value).shortValue(), BuiltInAtomicType.SHORT, false);
            }
            if (value instanceof String) {
                return new StringValue((String)value);
            }
            if (value instanceof BigDecimal) {
                return new DecimalValue((BigDecimal)value);
            }
            if (value instanceof BigInteger) {
                return new BigIntegerValue((BigInteger)value);
            }
            if (value instanceof SaxonDuration) {
                return ((SaxonDuration)value).getDurationValue();
            }
            if (value instanceof Duration) {
                return DurationValue.makeDuration(value.toString()).asAtomic();
            }
            if (value instanceof SaxonXMLGregorianCalendar) {
                return ((SaxonXMLGregorianCalendar)value).toCalendarValue();
            }
            if (value instanceof XMLGregorianCalendar) {
                XMLGregorianCalendar g = (XMLGregorianCalendar)value;
                QName gtype = g.getXMLSchemaType();
                if (gtype.equals(DatatypeConstants.DATETIME)) {
                    return DateTimeValue.makeDateTimeValue(gtype.toString()).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.DATE)) {
                    return DateValue.makeDateValue(gtype.toString()).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.TIME)) {
                    return TimeValue.makeTimeValue(gtype.toString()).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.GYEAR)) {
                    return GYearValue.makeGYearValue(gtype.toString()).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.GYEARMONTH)) {
                    return GYearMonthValue.makeGYearMonthValue(gtype.toString()).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.GMONTH)) {
                    return GMonthValue.makeGMonthValue(gtype.toString()).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.GMONTHDAY)) {
                    return GMonthDayValue.makeGMonthDayValue(gtype.toString()).asAtomic();
                }
                if (gtype.equals(DatatypeConstants.GDAY)) {
                    return GDayValue.makeGDayValue(gtype.toString()).asAtomic();
                }
                throw new AssertionError((Object)"Unknown Gregorian date type");
            }
            if (value instanceof QName) {
                QName q = (QName)value;
                return new QNameValue(q.getPrefix(), q.getNamespaceURI(), q.getLocalPart(), BuiltInAtomicType.QNAME, null);
            }
            if (value instanceof Node) {
                JPConverter jp = DOMObjectModel.getInstance().getJPConverter(Node.class);
                return Value.asItem(jp.convert(value, new EarlyEvaluationContext(this.config, null)));
            }
            if (value instanceof Source) {
                TinyBuilder b = new TinyBuilder();
                PipelineConfiguration pipe = this.config.makePipelineConfiguration();
                b.setPipelineConfiguration(pipe);
                new Sender(pipe).send((Source)value, b, null);
                NodeInfo node = b.getCurrentRoot();
                ((Builder)b).reset();
                return node;
            }
            if (value instanceof XMLStreamReader) {
                StaxToEventBridge bridge = new StaxToEventBridge();
                bridge.setXMLStreamReader((XMLStreamReader)value);
                PipelineConfiguration pipe = this.config.makePipelineConfiguration();
                bridge.setPipelineConfiguration(pipe);
                TinyBuilder b = new TinyBuilder();
                b.setPipelineConfiguration(pipe);
                new Sender(pipe).send(new PullEventSource(bridge), b, null);
                NodeInfo node = b.getCurrentRoot();
                ((Builder)b).reset();
                return node;
            }
            throw new XPathException("Java object cannot be converted to an XQuery value");
        }
        catch (XPathException e) {
            XQException xqe = new XQException(e.getMessage());
            xqe.initCause((Throwable)e);
            throw xqe;
        }
    }

    @Override
    public Item convertToItem(Object value, XQItemType type) throws XQException {
        if (((SaxonXQItemType)type).getSaxonItemType() instanceof ExternalObjectType) {
            return new ObjectValue(value, (ExternalObjectType)((SaxonXQItemType)type).getSaxonItemType());
        }
        throw new XQException("Supplied Java object cannot be converted to an XQItem");
    }
}

