/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.xqj;

import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQSequenceType;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.value.SequenceType;
import net2.sf.saxon.xqj.SaxonXQItemType;

public class SaxonXQSequenceType
implements XQSequenceType {
    SequenceType sequenceType;
    Configuration config;

    SaxonXQSequenceType(SequenceType sequenceType, Configuration config) {
        this.sequenceType = sequenceType;
        this.config = config;
    }

    public int getItemOccurrence() {
        int cardinality = this.sequenceType.getCardinality();
        switch (cardinality) {
            case 16384: {
                return 2;
            }
            case 24576: {
                return 1;
            }
            case 49152: {
                return 4;
            }
            case 57344: {
                return 3;
            }
        }
        return 3;
    }

    public XQItemType getItemType() {
        return new SaxonXQItemType(this.sequenceType.getPrimaryType(), this.config);
    }

    public String getString() {
        String s = this.sequenceType.getPrimaryType().toString(this.config.getNamePool());
        switch (this.sequenceType.getCardinality()) {
            case 16384: {
                return s;
            }
            case 24576: {
                return String.valueOf(s) + "?";
            }
            case 49152: {
                return String.valueOf(s) + "+";
            }
            case 57344: {
                return String.valueOf(s) + "*";
            }
        }
        return s;
    }

    public String toString() {
        return this.getString();
    }
}

