/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.xqj;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQPreparedExpression;
import javax.xml.xquery.XQResultSequence;
import javax.xml.xquery.XQSequenceType;
import javax.xml.xquery.XQStaticContext;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.instruct.GlobalParam;
import net2.sf.saxon.instruct.GlobalVariable;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.query.DynamicQueryContext;
import net2.sf.saxon.query.XQueryExpression;
import net2.sf.saxon.sort.IntHashSet;
import net2.sf.saxon.sort.IntIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.value.SequenceExtent;
import net2.sf.saxon.value.SequenceType;
import net2.sf.saxon.value.Value;
import net2.sf.saxon.xqj.SaxonXQConnection;
import net2.sf.saxon.xqj.SaxonXQDataFactory;
import net2.sf.saxon.xqj.SaxonXQDynamicContext;
import net2.sf.saxon.xqj.SaxonXQExpressionContext;
import net2.sf.saxon.xqj.SaxonXQForwardSequence;
import net2.sf.saxon.xqj.SaxonXQSequence;
import net2.sf.saxon.xqj.SaxonXQSequenceType;
import net2.sf.saxon.xqj.SaxonXQStaticContext;

public class SaxonXQPreparedExpression
extends SaxonXQDynamicContext
implements XQPreparedExpression {
    private XQueryExpression expression;
    private SaxonXQStaticContext staticContext;
    private DynamicQueryContext context;
    private boolean scrollable;
    private static QName[] EMPTY_QNAME_ARRAY = new QName[0];

    protected SaxonXQPreparedExpression(SaxonXQConnection connection, XQueryExpression expression, SaxonXQStaticContext sqc, DynamicQueryContext context) throws XQException {
        this.connection = connection;
        this.expression = expression;
        this.staticContext = sqc;
        this.context = context;
        this.scrollable = sqc.getScrollability() == 2;
        this.setClosableContainer(connection);
    }

    @Override
    protected DynamicQueryContext getDynamicContext() {
        return this.context;
    }

    protected SaxonXQConnection getConnection() {
        return this.connection;
    }

    @Override
    protected SaxonXQDataFactory getDataFactory() throws XQException {
        if (this.connection.isClosed()) {
            this.close();
        }
        this.checkNotClosed();
        return this.connection;
    }

    protected XQueryExpression getXQueryExpression() {
        return this.expression;
    }

    protected SaxonXQStaticContext getSaxonXQStaticContext() {
        return this.staticContext;
    }

    public void cancel() throws XQException {
        this.checkNotClosed();
    }

    public XQResultSequence executeQuery() throws XQException {
        this.checkNotClosed();
        try {
            SequenceIterator iter = this.expression.iterator(this.context);
            if (this.scrollable) {
                Value value = Value.asValue(SequenceExtent.makeSequenceExtent(iter));
                return new SaxonXQSequence(value, this);
            }
            return new SaxonXQForwardSequence(iter, this);
        }
        catch (XPathException de) {
            XQException xqe = new XQException(de.getMessage());
            xqe.initCause((Throwable)de);
            throw xqe;
        }
    }

    public QName[] getAllExternalVariables() throws XQException {
        this.checkNotClosed();
        HashMap<StructuredQName, GlobalVariable> vars = this.expression.getExecutable().getCompiledGlobalVariables();
        if (vars == null || vars.isEmpty()) {
            return EMPTY_QNAME_ARRAY;
        }
        HashSet<StructuredQName> params = new HashSet<StructuredQName>(vars.size());
        for (GlobalVariable var : vars.values()) {
            if (!(var instanceof GlobalParam)) continue;
            params.add(var.getVariableQName());
        }
        QName[] qnames = new QName[params.size()];
        int q = 0;
        for (StructuredQName name : params) {
            qnames[q++] = new QName(name.getNamespaceURI(), name.getLocalName(), name.getPrefix());
        }
        return qnames;
    }

    public QName[] getAllUnboundExternalVariables() throws XQException {
        this.checkNotClosed();
        Set<String> boundParameters = this.getDynamicContext().getParameters().keySet();
        IntHashSet unbound = new IntHashSet(boundParameters.size());
        QName[] all = this.getAllExternalVariables();
        int i = 0;
        while (i < all.length) {
            String clark = "{" + all[i].getNamespaceURI() + "}" + all[i].getLocalPart();
            if (!boundParameters.contains(clark)) {
                unbound.add(i);
            }
            ++i;
        }
        QName[] unboundq = new QName[unbound.size()];
        int c = 0;
        IntIterator iter = unbound.iterator();
        while (iter.hasNext()) {
            int x = iter.next();
            unboundq[c++] = all[x];
        }
        return unboundq;
    }

    public XQStaticContext getStaticContext() throws XQException {
        this.checkNotClosed();
        return new SaxonXQExpressionContext(this.expression);
    }

    public XQSequenceType getStaticResultType() throws XQException {
        this.checkNotClosed();
        Expression exp = this.expression.getExpression();
        ItemType itemType = exp.getItemType(this.connection.getConfiguration().getTypeHierarchy());
        int cardinality = exp.getCardinality();
        SequenceType staticType = SequenceType.makeSequenceType(itemType, cardinality);
        return new SaxonXQSequenceType(staticType, this.connection.getConfiguration());
    }

    public XQSequenceType getStaticVariableType(QName name) throws XQException {
        GlobalVariable var;
        this.checkNotClosed();
        this.checkNotNull(name);
        StructuredQName qn = new StructuredQName(name.getPrefix(), name.getNamespaceURI(), name.getLocalPart());
        HashMap<StructuredQName, GlobalVariable> vars = this.expression.getExecutable().getCompiledGlobalVariables();
        GlobalVariable globalVariable = var = vars == null ? null : vars.get(qn);
        if (var == null) {
            throw new XQException("Variable " + name + " is not declared");
        }
        return new SaxonXQSequenceType(var.getRequiredType(), this.connection.getConfiguration());
    }

    @Override
    protected boolean externalVariableExists(QName name) {
        GlobalVariable var;
        StructuredQName qn = new StructuredQName(name.getPrefix(), name.getNamespaceURI(), name.getLocalPart());
        HashMap<StructuredQName, GlobalVariable> vars = this.expression.getExecutable().getCompiledGlobalVariables();
        GlobalVariable globalVariable = var = vars == null ? null : vars.get(qn);
        return var != null && var instanceof GlobalParam;
    }

    private void checkNotNull(Object arg) throws XQException {
        if (arg == null) {
            throw new XQException("Argument is null");
        }
    }
}

