/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.xpath;

import java.util.ArrayList;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.FunctionCall;
import net2.sf.saxon.expr.JPConverter;
import net2.sf.saxon.expr.PJConverter;
import net2.sf.saxon.expr.PathMap;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.EmptyIterator;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.ValueRepresentation;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.Type;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.Value;

public class XPathFunctionCall
extends FunctionCall {
    private XPathFunction function;

    public XPathFunctionCall(XPathFunction function) {
        this.function = function;
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    @Override
    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
    }

    @Override
    public int getIntrinsicDependencies() {
        return 0;
    }

    @Override
    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return this.addExternalFunctionCallToPathMap(pathMap, pathMapNodeSet);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        ValueRepresentation[] argValues = new ValueRepresentation[this.argument.length];
        int i = 0;
        while (i < argValues.length) {
            argValues[i] = ExpressionTool.lazyEvaluate(this.argument[i], context, 10);
            ++i;
        }
        return this.call(argValues, context);
    }

    protected SequenceIterator call(ValueRepresentation[] argValues, XPathContext context) throws XPathException {
        ArrayList<Object> convertedArgs = new ArrayList<Object>(argValues.length);
        Configuration config = context.getConfiguration();
        int i = 0;
        while (i < argValues.length) {
            Value actual = Value.asValue(argValues[i]).reduce();
            PJConverter converter = PJConverter.allocate(config, actual.getItemType(config.getTypeHierarchy()), actual.getCardinality(), Object.class);
            convertedArgs.add(converter.convert(actual, Object.class, context));
            ++i;
        }
        try {
            Object result = this.function.evaluate(convertedArgs);
            if (result == null) {
                return EmptyIterator.getInstance();
            }
            JPConverter converter = JPConverter.allocate(result.getClass(), config);
            return Value.asIterator(converter.convert(result, context));
        }
        catch (XPathFunctionException e) {
            throw new XPathException(e);
        }
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return Type.ITEM_TYPE;
    }

    @Override
    public int computeCardinality() {
        return 57344;
    }
}

