/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.xpath;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.xpath.XPathEvaluator;

public class XPathFactoryImpl
extends XPathFactory {
    private Configuration config;
    private XPathVariableResolver variableResolver;
    private XPathFunctionResolver functionResolver;
    private static String FEATURE_SECURE_PROCESSING = "http://javax.xml.XMLConstants/feature/secure-processing";

    public XPathFactoryImpl() {
        this.config = Configuration.newConfiguration();
        this.setConfiguration(this.config);
    }

    public XPathFactoryImpl(Configuration config) {
        this.config = config;
        config.setProcessor(this);
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        config.setProcessor(this);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public boolean isObjectModelSupported(String model) {
        boolean debug;
        boolean bl = debug = System.getProperty("jaxp.debug") != null;
        if (debug) {
            System.err.println("JAXP: Calling " + this.getClass().getName() + ".isObjectModelSupported(\"" + model + "\")");
            System.err.println("JAXP: -- returning " + this.silentIsObjectModelSupported(model));
        }
        return this.silentIsObjectModelSupported(model);
    }

    private boolean silentIsObjectModelSupported(String model) {
        return model.equals("http://saxon.sf.net/jaxp/xpath/om") || this.config.getExternalObjectModel(model) != null;
    }

    @Override
    public void setFeature(String feature, boolean b) throws XPathFactoryConfigurationException {
        if (feature.equals(FEATURE_SECURE_PROCESSING)) {
            this.config.setAllowExternalFunctions(!b);
        } else if (feature.equals("http://saxon.sf.net/feature/schema-validation")) {
            this.config.setSchemaValidationMode(b ? 1 : 4);
        } else {
            throw new XPathFactoryConfigurationException("Unknown feature: " + feature);
        }
    }

    @Override
    public boolean getFeature(String feature) throws XPathFactoryConfigurationException {
        if (feature.equals(FEATURE_SECURE_PROCESSING)) {
            return !this.config.isAllowExternalFunctions();
        }
        if (feature.equals("http://saxon.sf.net/feature/schema-validation")) {
            return this.config.getSchemaValidationMode() == 1;
        }
        throw new XPathFactoryConfigurationException("Unknown feature: " + feature);
    }

    @Override
    public void setXPathVariableResolver(XPathVariableResolver xPathVariableResolver) {
        this.variableResolver = xPathVariableResolver;
    }

    @Override
    public void setXPathFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        this.functionResolver = xPathFunctionResolver;
    }

    @Override
    public XPath newXPath() {
        XPathEvaluator xpath = new XPathEvaluator(this.config);
        xpath.setXPathFunctionResolver(this.functionResolver);
        xpath.setXPathVariableResolver(this.variableResolver);
        return xpath;
    }
}

