/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.xpath;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import net2.sf.saxon.AugmentedSource;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.dom.DocumentWrapper;
import net2.sf.saxon.dom.NodeWrapper;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.XPathContextMajor;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.instruct.SlotManager;
import net2.sf.saxon.om.AllElementStripper;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.SpaceStrippedDocument;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.SchemaException;
import net2.sf.saxon.type.Type;
import net2.sf.saxon.value.Value;
import net2.sf.saxon.xpath.JAXPXPathStaticContext;
import net2.sf.saxon.xpath.XPathExpressionImpl;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XPathEvaluator
implements XPath {
    private Configuration config;
    private NodeInfo contextNode = null;
    private JAXPXPathStaticContext staticContext;
    private boolean stripSpace = false;

    public XPathEvaluator() {
        this(Configuration.newConfiguration());
    }

    public XPathEvaluator(Configuration config) {
        this.config = config;
        this.staticContext = new JAXPXPathStaticContext(config);
    }

    public XPathEvaluator(Source source) throws XPathException {
        this.config = source instanceof NodeInfo ? ((NodeInfo)source).getDocumentRoot().getConfiguration() : new Configuration();
        this.staticContext = new JAXPXPathStaticContext(this.config);
        this.setSource(source);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setStripSpace(boolean strip) {
        this.stripSpace = strip;
    }

    public NodeInfo setSource(Source source) throws XPathException {
        if (source instanceof DOMSource) {
            Node node = ((DOMSource)source).getNode();
            String baseURI = source.getSystemId();
            DocumentWrapper documentWrapper = new DocumentWrapper((Node)node.getOwnerDocument(), baseURI, this.config);
            NodeWrapper nodeWrapper = documentWrapper.wrap(node);
            if (this.stripSpace) {
                SpaceStrippedDocument sdoc = new SpaceStrippedDocument(documentWrapper, AllElementStripper.getInstance());
                return sdoc.wrap(nodeWrapper);
            }
            return nodeWrapper;
        }
        if (source instanceof NodeInfo) {
            NodeInfo origin = (NodeInfo)source;
            if (!origin.getConfiguration().isCompatible(this.config)) {
                throw new XPathException("Supplied node must be built using the same or a compatible Configuration", "SXXP0004");
            }
            if (this.stripSpace) {
                SpaceStrippedDocument sdoc = new SpaceStrippedDocument(origin.getDocumentRoot(), AllElementStripper.getInstance());
                return sdoc.wrap(origin);
            }
            return origin;
        }
        if (this.stripSpace) {
            AugmentedSource as = AugmentedSource.makeAugmentedSource(source);
            as.setStripSpace(2);
            source = as;
        }
        return this.config.buildDocument(source);
    }

    public void setStaticContext(JAXPXPathStaticContext context) {
        if (!this.config.isCompatible(context.getConfiguration())) {
            throw new IllegalArgumentException("Supplied static context uses a different and incompatible Configuration");
        }
        this.staticContext = context;
    }

    public JAXPXPathStaticContext getStaticContext() {
        return this.staticContext;
    }

    public Executable getExecutable() {
        return this.staticContext.getExecutable();
    }

    public XPathExpressionImpl createExpression(String expression) throws XPathException {
        return this.createExpressionInternal(expression);
    }

    private XPathExpressionImpl createExpressionInternal(String expression) throws XPathException {
        Expression exp = ExpressionTool.make(expression, this.staticContext, 0, -1, 1, false);
        ExpressionVisitor visitor = ExpressionVisitor.make(this.staticContext);
        visitor.setExecutable(this.getExecutable());
        exp = visitor.typeCheck(exp, Type.ITEM_TYPE);
        SlotManager map = this.staticContext.getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots(exp, 0, map);
        exp.setContainer(this.staticContext);
        XPathExpressionImpl xpe = new XPathExpressionImpl(exp, this.getExecutable());
        xpe.setStackFrameMap(map);
        if (this.contextNode != null) {
            xpe.privatelySetContextNode(this.contextNode);
        }
        return xpe;
    }

    public void setContextNode(NodeInfo node) {
        if (!node.getConfiguration().isCompatible(this.config)) {
            throw new IllegalArgumentException("Supplied node must be built using the same or a compatible Configuration");
        }
        this.contextNode = node;
    }

    public List evaluate(String expression) throws XPathException {
        Expression exp = ExpressionTool.make(expression, this.staticContext, 0, -1, 1, false);
        ExpressionVisitor visitor = ExpressionVisitor.make(this.staticContext);
        visitor.setExecutable(this.getExecutable());
        exp = visitor.typeCheck(exp, Type.ITEM_TYPE);
        SlotManager map = this.staticContext.getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots(exp, 0, map);
        XPathContextMajor context = new XPathContextMajor((Item)this.contextNode, this.staticContext.getExecutable());
        context.openStackFrame(map);
        SequenceIterator iterator = exp.iterate(context);
        ArrayList<Object> list = new ArrayList<Object>(20);
        Item item;
        while ((item = iterator.next()) != null) {
            list.add(Value.convertToJava(item));
        }
        return list;
    }

    @Override
    public void reset() {
        this.contextNode = null;
        this.stripSpace = false;
        this.staticContext = new JAXPXPathStaticContext(this.config);
    }

    public void setBackwardsCompatible(boolean compatible) {
        this.staticContext.setBackwardsCompatibilityMode(compatible);
    }

    public boolean isBackwardsCompatible() {
        return this.staticContext.isInBackwardsCompatibleMode();
    }

    @Override
    public void setXPathVariableResolver(XPathVariableResolver xPathVariableResolver) {
        this.staticContext.setXPathVariableResolver(xPathVariableResolver);
    }

    @Override
    public XPathVariableResolver getXPathVariableResolver() {
        return this.staticContext.getXPathVariableResolver();
    }

    @Override
    public void setXPathFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        this.staticContext.setXPathFunctionResolver(xPathFunctionResolver);
    }

    @Override
    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.staticContext.getXPathFunctionResolver();
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.staticContext.setNamespaceContext(namespaceContext);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.staticContext.getNamespaceContext();
    }

    public void importSchema(Source source) throws SchemaException {
        this.staticContext.importSchema(source);
    }

    @Override
    public XPathExpression compile(String expr) throws XPathExpressionException {
        if (expr == null) {
            throw new NullPointerException("expr");
        }
        try {
            return this.createExpressionInternal(expr);
        }
        catch (XPathException e) {
            throw new XPathExpressionException(e);
        }
    }

    @Override
    public Object evaluate(String expr, Object node, QName qName) throws XPathExpressionException {
        XPathExpression exp = this.compile(expr);
        return exp.evaluate(node, qName);
    }

    @Override
    public String evaluate(String expr, Object node) throws XPathExpressionException {
        XPathExpression exp = this.compile(expr);
        return exp.evaluate(node);
    }

    @Override
    public Object evaluate(String expr, InputSource inputSource, QName qName) throws XPathExpressionException {
        if (expr == null) {
            throw new NullPointerException("expr");
        }
        if (inputSource == null) {
            throw new NullPointerException("inputSource");
        }
        if (qName == null) {
            throw new NullPointerException("qName");
        }
        XPathExpression exp = this.compile(expr);
        return exp.evaluate(inputSource, qName);
    }

    @Override
    public String evaluate(String expr, InputSource inputSource) throws XPathExpressionException {
        if (expr == null) {
            throw new NullPointerException("expr");
        }
        if (inputSource == null) {
            throw new NullPointerException("inputSource");
        }
        XPathExpression exp = this.compile(expr);
        return exp.evaluate(inputSource);
    }

    public Object evaluateSingle(String expression) throws XPathException {
        Expression exp = ExpressionTool.make(expression, this.staticContext, 0, -1, 1, false);
        ExpressionVisitor visitor = ExpressionVisitor.make(this.staticContext);
        visitor.setExecutable(this.getExecutable());
        exp = visitor.typeCheck(exp, Type.ITEM_TYPE);
        SlotManager map = this.staticContext.getConfiguration().makeSlotManager();
        ExpressionTool.allocateSlots(exp, 0, map);
        XPathContextMajor context = new XPathContextMajor((Item)this.contextNode, this.staticContext.getExecutable());
        context.openStackFrame(map);
        SequenceIterator iterator = exp.iterate(context);
        Item item = iterator.next();
        if (item == null) {
            return null;
        }
        return Value.convertToJava(item);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("format: java XPathEvaluator source.xml \"expression\"");
            return;
        }
        XPathEvaluator xpe = new XPathEvaluator();
        List results = (List)xpe.evaluate(args[1], new StreamSource(new File(args[0])), XPathConstants.NODESET);
        int i = 0;
        while (i < results.size()) {
            Object o = results.get(i);
            System.err.println(o);
            ++i;
        }
    }
}

