/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.value;

import java.math.BigDecimal;
import java.util.StringTokenizer;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.sort.StringCollator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.AtomicType;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ConversionResult;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.DecimalValue;
import net2.sf.saxon.value.DurationValue;
import net2.sf.saxon.value.Whitespace;

public final class YearMonthDurationValue
extends DurationValue
implements Comparable {
    private YearMonthDurationValue() {
        this.typeLabel = BuiltInAtomicType.YEAR_MONTH_DURATION;
    }

    public static ConversionResult makeYearMonthDurationValue(CharSequence s) {
        int years = 0;
        int months = 0;
        boolean negative = false;
        int components = 0;
        StringTokenizer tok = new StringTokenizer(Whitespace.trimWhitespace(s).toString(), "-+PYM", true);
        if (!tok.hasMoreElements()) {
            return YearMonthDurationValue.badDuration("empty string", s);
        }
        String part = (String)tok.nextElement();
        if ("+".equals(part)) {
            return YearMonthDurationValue.badDuration("+ sign not allowed in a duration", s);
        }
        if ("-".equals(part)) {
            negative = true;
            part = (String)tok.nextElement();
        }
        if (!"P".equals(part)) {
            return YearMonthDurationValue.badDuration("missing 'P'", s);
        }
        int state = 0;
        while (tok.hasMoreElements()) {
            part = (String)tok.nextElement();
            int value = YearMonthDurationValue.simpleInteger(part);
            if (value < 0) {
                return YearMonthDurationValue.badDuration("non-numeric component", s);
            }
            if (!tok.hasMoreElements()) {
                return YearMonthDurationValue.badDuration("missing unit letter at end", s);
            }
            char delim = ((String)tok.nextElement()).charAt(0);
            switch (delim) {
                case 'Y': {
                    if (state > 0) {
                        return YearMonthDurationValue.badDuration("Y is out of sequence", s);
                    }
                    years = value;
                    ++components;
                    state = 1;
                    break;
                }
                case 'M': {
                    if (state == 0 || state == 1) {
                        months = value;
                        ++components;
                        state = 2;
                        break;
                    }
                    return YearMonthDurationValue.badDuration("M is out of sequence", s);
                }
                default: {
                    return YearMonthDurationValue.badDuration("misplaced " + delim, s);
                }
            }
        }
        if (components == 0) {
            return YearMonthDurationValue.badDuration("duration specifies no components", s);
        }
        if ((long)years + (long)months * 12L > Integer.MAX_VALUE) {
            return YearMonthDurationValue.badDuration("duration exceeds limits", s);
        }
        return YearMonthDurationValue.fromMonths((years * 12 + months) * (negative ? -1 : 1));
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        YearMonthDurationValue v = YearMonthDurationValue.fromMonths(this.getLengthInMonths());
        v.typeLabel = typeLabel;
        return v;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.YEAR_MONTH_DURATION;
    }

    @Override
    public CharSequence getPrimitiveStringValue() {
        int y = this.getYears();
        int m = this.getMonths();
        FastStringBuffer sb = new FastStringBuffer(32);
        if (this.negative) {
            sb.append('-');
        }
        sb.append('P');
        if (y != 0) {
            sb.append(String.valueOf(y) + "Y");
        }
        if (m != 0 || y == 0) {
            sb.append(String.valueOf(m) + "M");
        }
        return sb;
    }

    public int getLengthInMonths() {
        return this.months * (this.negative ? -1 : 1);
    }

    public static YearMonthDurationValue fromMonths(int months) {
        YearMonthDurationValue mdv = new YearMonthDurationValue();
        mdv.negative = months < 0;
        mdv.months = months < 0 ? -months : months;
        mdv.seconds = 0L;
        mdv.microseconds = 0;
        return mdv;
    }

    @Override
    public DurationValue multiply(double n) throws XPathException {
        if (Double.isNaN(n)) {
            XPathException err = new XPathException("Cannot multiply/divide a duration by NaN");
            err.setErrorCode("FOCA0005");
            throw err;
        }
        double m = this.getLengthInMonths();
        double product = n * m;
        if (Double.isInfinite(product) || product > 2.147483647E9 || product < -2.147483648E9) {
            XPathException err = new XPathException("Overflow when multiplying/dividing a duration by a number");
            err.setErrorCode("FODT0002");
            throw err;
        }
        return YearMonthDurationValue.fromMonths((int)Math.round(product));
    }

    @Override
    public DecimalValue divide(DurationValue other) throws XPathException {
        if (other instanceof YearMonthDurationValue) {
            BigDecimal v1 = BigDecimal.valueOf(this.getLengthInMonths());
            BigDecimal v2 = BigDecimal.valueOf(((YearMonthDurationValue)other).getLengthInMonths());
            if (v2.signum() == 0) {
                XPathException err = new XPathException("Divide by zero (durations)");
                err.setErrorCode("FOAR0001");
                throw err;
            }
            return new DecimalValue(v1.divide(v2, 20, 6));
        }
        XPathException err = new XPathException("Cannot divide two durations of different type");
        err.setErrorCode("XPTY0004");
        throw err;
    }

    @Override
    public DurationValue add(DurationValue other) throws XPathException {
        if (other instanceof YearMonthDurationValue) {
            return YearMonthDurationValue.fromMonths(this.getLengthInMonths() + ((YearMonthDurationValue)other).getLengthInMonths());
        }
        XPathException err = new XPathException("Cannot add two durations of different type");
        err.setErrorCode("XPTY0004");
        throw err;
    }

    @Override
    public DurationValue subtract(DurationValue other) throws XPathException {
        if (other instanceof YearMonthDurationValue) {
            return YearMonthDurationValue.fromMonths(this.getLengthInMonths() - ((YearMonthDurationValue)other).getLengthInMonths());
        }
        XPathException err = new XPathException("Cannot subtract two durations of different type");
        err.setErrorCode("XPTY0004");
        throw err;
    }

    @Override
    public DurationValue negate() {
        return YearMonthDurationValue.fromMonths(-this.getLengthInMonths());
    }

    public int compareTo(Object other) {
        if (other instanceof YearMonthDurationValue) {
            return this.getLengthInMonths() - ((YearMonthDurationValue)other).getLengthInMonths();
        }
        throw new ClassCastException("Cannot compare a yearMonthDuration to an object of class " + other.getClass());
    }

    @Override
    public Object getXPathComparable(boolean ordered, StringCollator collator, XPathContext context) {
        return this;
    }
}

