/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.value;

import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.tinytree.CompressedWhitespace;

public class Whitespace {
    public static final int PRESERVE = 0;
    public static final int REPLACE = 1;
    public static final int COLLAPSE = 2;
    public static final int NONE = 0;
    public static final int IGNORABLE = 1;
    public static final int ALL = 2;
    public static final int UNSPECIFIED = 3;
    public static final int XSLT = 4;
    private static boolean[] C0WHITE;

    static {
        boolean[] blArray = new boolean[33];
        blArray[9] = true;
        blArray[10] = true;
        blArray[13] = true;
        blArray[32] = true;
        C0WHITE = blArray;
    }

    private Whitespace() {
    }

    public static boolean isWhitespace(int ch) {
        switch (ch) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static CharSequence applyWhitespaceNormalization(int action, CharSequence value) {
        switch (action) {
            case 0: {
                return value;
            }
            case 1: {
                FastStringBuffer sb = new FastStringBuffer(value.length());
                int i = 0;
                while (i < value.length()) {
                    char c = value.charAt(i);
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\r': {
                            sb.append(' ');
                            break;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                    ++i;
                }
                return sb;
            }
            case 2: {
                return Whitespace.collapseWhitespace(value);
            }
        }
        throw new IllegalArgumentException("Unknown whitespace facet value");
    }

    public static CharSequence removeAllWhitespace(CharSequence value) {
        if (Whitespace.containsWhitespace(value)) {
            FastStringBuffer sb = new FastStringBuffer(value.length());
            int i = 0;
            while (i < value.length()) {
                char c = value.charAt(i);
                if (c > ' ' || !C0WHITE[c]) {
                    sb.append(c);
                }
                ++i;
            }
            return sb;
        }
        return value;
    }

    public static CharSequence removeLeadingWhitespace(CharSequence value) {
        int start = -1;
        int len = value.length();
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c > ' ' || !C0WHITE[c]) {
                start = i;
                break;
            }
            ++i;
        }
        if (start == 0) {
            return value;
        }
        if (start < 0 || start == len - 1) {
            return "";
        }
        return value.subSequence(start, len);
    }

    public static boolean containsWhitespace(CharSequence value) {
        int len = value.length();
        int i = 0;
        while (i < len) {
            char c;
            if ((c = value.charAt(i++)) > ' ' || !C0WHITE[c]) continue;
            return true;
        }
        return false;
    }

    public static boolean isWhite(CharSequence content) {
        if (content instanceof CompressedWhitespace) {
            return true;
        }
        int len = content.length();
        int i = 0;
        while (i < len) {
            char c;
            if ((c = content.charAt(i++)) <= ' ' && C0WHITE[c]) continue;
            return false;
        }
        return true;
    }

    public static CharSequence normalizeWhitespace(CharSequence in) {
        FastStringBuffer sb = new FastStringBuffer(in.length());
        int i = 0;
        while (i < in.length()) {
            char c = in.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': {
                    sb.append(' ');
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb;
    }

    public static CharSequence collapseWhitespace(CharSequence in) {
        int len = in.length();
        if (len == 0 || !Whitespace.containsWhitespace(in)) {
            return in;
        }
        FastStringBuffer sb = new FastStringBuffer(len);
        boolean inWhitespace = true;
        int i = 0;
        while (i < len) {
            char c = in.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (inWhitespace) break;
                    sb.append(' ');
                    inWhitespace = true;
                    break;
                }
                default: {
                    sb.append(c);
                    inWhitespace = false;
                }
            }
            ++i;
        }
        int nlen = sb.length();
        if (nlen > 0 && sb.charAt(nlen - 1) == ' ') {
            sb.setLength(nlen - 1);
        }
        return sb;
    }

    public static CharSequence trimWhitespace(CharSequence in) {
        char x;
        if (in.length() == 0) {
            return in;
        }
        int first = 0;
        int last = in.length() - 1;
        while ((x = in.charAt(first)) <= ' ' && C0WHITE[x]) {
            if (first++ < last) continue;
            return "";
        }
        while ((x = in.charAt(last)) <= ' ' && C0WHITE[x]) {
            --last;
        }
        if (first == 0 && last == in.length() - 1) {
            return in;
        }
        return in.subSequence(first, last + 1);
    }

    public static String trim(CharSequence s) {
        if (s == null) {
            return null;
        }
        return Whitespace.trimWhitespace(s).toString();
    }
}

