/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.value;

import net2.sf.saxon.event.SequenceReceiver;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.SingletonIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.Closure;
import net2.sf.saxon.value.Value;

public class SingletonClosure
extends Closure {
    private boolean built = false;
    private Item value = null;

    public SingletonClosure(Expression exp, XPathContext context) throws XPathException {
        this.expression = exp;
        this.savedXPathContext = context.newContext();
        this.saveContext(exp, context);
    }

    @Override
    public SequenceIterator iterate() throws XPathException {
        return SingletonIterator.makeIterator(this.asItem());
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        SequenceReceiver out = context.getReceiver();
        out.append(this.asItem(), 0, 2);
    }

    @Override
    public Item asItem() throws XPathException {
        if (!this.built) {
            this.value = this.expression.evaluateItem(this.savedXPathContext);
            this.built = true;
            this.savedXPathContext = null;
        }
        return this.value;
    }

    @Override
    public Item itemAt(int n) throws XPathException {
        if (n != 0) {
            return null;
        }
        return this.asItem();
    }

    @Override
    public int getLength() throws XPathException {
        return this.asItem() == null ? 0 : 1;
    }

    public Value materialize() throws XPathException {
        return Value.asValue(this.asItem());
    }
}

