/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.value;

import java.util.List;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.ListIterator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.AnyItemType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.Type;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.EmptySequence;
import net2.sf.saxon.value.Value;

public final class ShareableSequence
extends Value {
    private List list;
    private int end;
    private ItemType itemType = null;

    public ShareableSequence(List list) {
        this.list = list;
        this.end = list.size();
    }

    public boolean isShareable() {
        return this.list.size() == this.end;
    }

    public List getList() {
        return this.list;
    }

    public Value simplify() {
        int n = this.getLength();
        if (n == 0) {
            return EmptySequence.getInstance();
        }
        if (n == 1) {
            return Value.asValue(this.itemAt(0));
        }
        return this;
    }

    @Override
    public Value reduce() {
        return this.simplify();
    }

    @Override
    public int getLength() {
        return this.end;
    }

    @Override
    public int getCardinality() {
        switch (this.end) {
            case 0: {
                return 8192;
            }
            case 1: {
                return 16384;
            }
        }
        return 49152;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        if (this.itemType != null) {
            return this.itemType;
        }
        if (this.end == 0) {
            this.itemType = AnyItemType.getInstance();
        } else {
            this.itemType = Type.getItemType(this.itemAt(0), th);
            int i = 1;
            while (i < this.end) {
                if (this.itemType == AnyItemType.getInstance()) {
                    return this.itemType;
                }
                this.itemType = Type.getCommonSuperType(this.itemType, Type.getItemType(this.itemAt(i), th), th);
                ++i;
            }
        }
        return this.itemType;
    }

    @Override
    public Item itemAt(int n) {
        if (n < 0 || n >= this.getLength()) {
            return null;
        }
        return (Item)this.list.get(n);
    }

    @Override
    public SequenceIterator iterate() {
        return new ListIterator(this.list, this.end);
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        int len = this.getLength();
        if (len == 0) {
            return false;
        }
        if (this.itemAt(0) instanceof NodeInfo) {
            return true;
        }
        if (len > 1) {
            return ExpressionTool.effectiveBooleanValue(this.iterate());
        }
        return ((AtomicValue)this.itemAt(0)).effectiveBooleanValue();
    }
}

