/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.value;

import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.NameChecker;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.AtomicType;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ConversionResult;
import net2.sf.saxon.type.ValidationFailure;
import net2.sf.saxon.value.AnyURIValue;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.QualifiedNameValue;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.UntypedAtomicValue;

public class QNameValue
extends QualifiedNameValue {
    public QNameValue(String prefix, String uri, String localName) {
        this(prefix, uri, localName, BuiltInAtomicType.QNAME);
    }

    public QNameValue(String prefix, String uri, String localName, AtomicType type) {
        this.qName = new StructuredQName(prefix, uri, localName);
        if (type == null) {
            type = BuiltInAtomicType.QNAME;
        }
        this.typeLabel = type;
    }

    public QNameValue(NamePool namePool, int nameCode) {
        String prefix = namePool.getPrefix(nameCode);
        String uri = namePool.getURI(nameCode);
        String localPart = namePool.getLocalName(nameCode);
        this.qName = new StructuredQName(prefix, uri, localPart);
        this.typeLabel = BuiltInAtomicType.QNAME;
    }

    public QNameValue(String prefix, String uri, String localName, AtomicType type, NameChecker checker) throws XPathException {
        if (checker != null && !checker.isValidNCName(localName)) {
            XPathException err = new XPathException("Malformed local name in QName: '" + localName + '\'');
            err.setErrorCode("FORG0001");
            throw err;
        }
        prefix = prefix == null ? "" : prefix;
        String string = uri = "".equals(uri) ? null : uri;
        if (checker != null && uri == null && prefix.length() != 0) {
            XPathException err = new XPathException("QName has null namespace but non-empty prefix");
            err.setErrorCode("FOCA0002");
            throw err;
        }
        this.qName = new StructuredQName(prefix, uri, localName);
        this.typeLabel = type;
    }

    public QNameValue(StructuredQName qName, AtomicType typeLabel) {
        this.qName = qName;
        this.typeLabel = typeLabel;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        return new QNameValue(this.qName, typeLabel);
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.QNAME;
    }

    @Override
    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        switch (requiredType.getPrimitiveType()) {
            case 530: 
            case 632: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert QName to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }

    @Override
    public AtomicValue getComponent(int part) {
        if (part == 8) {
            return (AtomicValue)StringValue.makeRestrictedString(this.getLocalName(), BuiltInAtomicType.NCNAME, null);
        }
        if (part == 9) {
            return new AnyURIValue(this.getNamespaceURI());
        }
        if (part == 10) {
            String prefix = this.getPrefix();
            if (prefix.length() == 0) {
                return null;
            }
            return (AtomicValue)StringValue.makeRestrictedString(prefix, BuiltInAtomicType.NCNAME, null);
        }
        throw new UnsupportedOperationException("Component of QName must be URI, Local Name, or Prefix");
    }

    @Override
    public boolean equals(Object other) {
        return this.qName.equals(((QNameValue)other).qName);
    }

    @Override
    public Comparable getSchemaComparable() {
        return new QNameComparable();
    }

    private class QNameComparable
    implements Comparable {
        private QNameComparable() {
        }

        public QNameValue getQNameValue() {
            return QNameValue.this;
        }

        public int compareTo(Object o) {
            return this.equals(o) ? 0 : Integer.MIN_VALUE;
        }

        public boolean equals(Object o) {
            return o instanceof QNameComparable && QNameValue.this.qName.equals(((QNameComparable)o).getQNameValue().qName);
        }

        public int hashCode() {
            return QNameValue.this.qName.hashCode();
        }
    }
}

