/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.value;

import net2.sf.saxon.Configuration;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.sort.StringCollator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.AtomicType;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ConversionResult;
import net2.sf.saxon.type.ExternalObjectType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.BooleanValue;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.UntypedAtomicValue;

public class ObjectValue
extends AtomicValue {
    private Object value;
    private static final ExternalObjectType objectType = new ExternalObjectType(Object.class);

    public ObjectValue() {
        this.typeLabel = objectType;
    }

    public ObjectValue(Object object) {
        this.value = object;
        this.typeLabel = new ExternalObjectType(object.getClass());
    }

    public ObjectValue(Object object, ExternalObjectType type) {
        this.value = object;
        this.typeLabel = type;
    }

    public void setValue(Object value) {
        this.value = value;
        this.typeLabel = new ExternalObjectType(value.getClass());
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        ObjectValue v = new ObjectValue(this.value);
        v.typeLabel = typeLabel;
        return v;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        if (this.typeLabel.equals(BuiltInAtomicType.ANY_ATOMIC)) {
            if (th == null) {
                throw new NullPointerException("No TypeHierarchy supplied");
            }
            Configuration config = th.getConfiguration();
            this.typeLabel = new ExternalObjectType(this.value.getClass(), config);
        }
        return this.typeLabel;
    }

    public String displayTypeName() {
        return "java-type:" + this.value.getClass().getName();
    }

    @Override
    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        switch (requiredType.getPrimitiveType()) {
            case 285: 
            case 632: {
                return this;
            }
            case 514: {
                return BooleanValue.get(this.value != null && this.value.toString().length() > 0);
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        return new StringValue(this.getStringValue()).convertPrimitive(requiredType, validate, context);
    }

    @Override
    public CharSequence getPrimitiveStringValue() {
        return this.value == null ? "" : this.value.toString();
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return this.value != null;
    }

    public Object getObject() {
        return this.value;
    }

    @Override
    public Comparable getSchemaComparable() {
        throw new UnsupportedOperationException("External objects cannot be compared according to XML Schema rules");
    }

    @Override
    public Object getXPathComparable(boolean ordered, StringCollator collator, XPathContext context) {
        return ordered ? null : this;
    }

    @Override
    public boolean equals(Object other) {
        return this.value.equals(((ObjectValue)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

