/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.value;

import java.util.ArrayList;
import net2.sf.saxon.Controller;
import net2.sf.saxon.event.SequenceOutputter;
import net2.sf.saxon.event.SequenceReceiver;
import net2.sf.saxon.event.TeeOutputter;
import net2.sf.saxon.expr.LastPositionFinder;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.expr.XPathContextMinor;
import net2.sf.saxon.om.ArrayIterator;
import net2.sf.saxon.om.EmptyIterator;
import net2.sf.saxon.om.GroundedIterator;
import net2.sf.saxon.om.GroundedValue;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.SingletonIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.Closure;
import net2.sf.saxon.value.EmptySequence;
import net2.sf.saxon.value.SequenceExtent;
import net2.sf.saxon.value.Value;

public class MemoClosure
extends Closure {
    private Item[] reservoir = null;
    private int used;
    protected int state;
    private static final int UNREAD = 0;
    private static final int MAYBE_MORE = 1;
    private static final int ALL_READ = 3;
    private static final int BUSY = 4;
    protected static final int EMPTY = 5;

    @Override
    public SequenceIterator iterate() throws XPathException {
        switch (this.state) {
            case 0: {
                this.state = 4;
                this.inputIterator = this.expression.iterate(this.savedXPathContext);
                if (this.inputIterator instanceof EmptyIterator) {
                    this.state = 5;
                    return this.inputIterator;
                }
                this.reservoir = new Item[50];
                this.used = 0;
                this.state = 1;
                return new ProgressiveIterator();
            }
            case 1: {
                return new ProgressiveIterator();
            }
            case 3: {
                switch (this.used) {
                    case 0: {
                        this.state = 5;
                        return EmptyIterator.getInstance();
                    }
                    case 1: {
                        return SingletonIterator.makeIterator(this.reservoir[0]);
                    }
                }
                return new ArrayIterator(this.reservoir, 0, this.used);
            }
            case 4: {
                XPathException de = new XPathException("Attempt to access a variable while it is being evaluated");
                de.setErrorCode("XTDE0640");
                throw de;
            }
            case 5: {
                return EmptyIterator.getInstance();
            }
        }
        throw new IllegalStateException("Unknown iterator state");
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        if (this.state == 5) {
            return;
        }
        if (this.state == 4) {
            XPathException de = new XPathException("Attempt to access a variable while it is being evaluated");
            de.setErrorCode("XTDE0640");
            de.setXPathContext(context);
            throw de;
        }
        if (this.reservoir != null) {
            Item it;
            SequenceIterator iter = this.iterate();
            SequenceReceiver out = context.getReceiver();
            while ((it = iter.next()) != null) {
                out.append(it, 0, 2);
            }
        } else {
            this.state = 4;
            Controller controller = context.getController();
            XPathContextMinor c2 = this.savedXPathContext.newMinorContext();
            SequenceOutputter seq = controller.allocateSequenceOutputter(20);
            seq.setPipelineConfiguration(controller.makePipelineConfiguration());
            seq.open();
            TeeOutputter tee = new TeeOutputter(context.getReceiver(), seq);
            tee.setPipelineConfiguration(controller.makePipelineConfiguration());
            c2.setTemporaryReceiver(tee);
            this.expression.process(c2);
            seq.close();
            ArrayList list = seq.getList();
            if (list.isEmpty()) {
                this.state = 5;
            } else {
                this.reservoir = new Item[list.size()];
                this.reservoir = list.toArray(this.reservoir);
                this.used = list.size();
                this.state = 3;
            }
            this.savedXPathContext = null;
            seq.reset();
        }
    }

    @Override
    public Item itemAt(int n) throws XPathException {
        if (n < 0) {
            return null;
        }
        if (this.reservoir != null && n < this.used) {
            return this.reservoir[n];
        }
        if (this.state == 3 || this.state == 5) {
            return null;
        }
        if (this.state == 0) {
            return super.itemAt(n);
        }
        int diff = n - this.used + 1;
        while (diff-- > 0) {
            Item i = this.inputIterator.next();
            if (i == null) {
                this.state = 3;
                this.condense();
                return this.itemAt(n);
            }
            this.append(i);
            this.state = 1;
        }
        return this.reservoir[n];
    }

    @Override
    public int getLength() throws XPathException {
        if (this.state == 3) {
            return this.used;
        }
        if (this.state == 5) {
            return 0;
        }
        return super.getLength();
    }

    private void append(Item item) {
        if (this.used >= this.reservoir.length) {
            Item[] r2 = new Item[this.used * 2];
            System.arraycopy(this.reservoir, 0, r2, 0, this.used);
            this.reservoir = r2;
        }
        this.reservoir[this.used++] = item;
    }

    private void condense() {
        if (this.reservoir.length - this.used > 30) {
            Item[] r2 = new Item[this.used];
            System.arraycopy(this.reservoir, 0, r2, 0, this.used);
            this.reservoir = r2;
        }
        this.savedXPathContext = null;
    }

    public boolean isFullyRead() {
        return this.state == 5 || this.state == 3;
    }

    public Value materialize() throws XPathException {
        if (this.state == 3) {
            return new SequenceExtent(this.reservoir, 0, this.used);
        }
        if (this.state == 5) {
            return EmptySequence.getInstance();
        }
        return new SequenceExtent(this.iterate());
    }

    public final class ProgressiveIterator
    implements SequenceIterator,
    LastPositionFinder,
    GroundedIterator {
        int position = -1;

        @Override
        public Item next() throws XPathException {
            if (this.position == -2) {
                return null;
            }
            if (++this.position < MemoClosure.this.used) {
                return MemoClosure.this.reservoir[this.position];
            }
            if (MemoClosure.this.state == 3) {
                this.position = -2;
                return null;
            }
            Item i = MemoClosure.this.inputIterator.next();
            if (i == null) {
                MemoClosure.this.state = 3;
                MemoClosure.this.condense();
                this.position = -2;
                return null;
            }
            this.position = MemoClosure.this.used;
            MemoClosure.this.append(i);
            MemoClosure.this.state = 1;
            return i;
        }

        @Override
        public Item current() {
            if (this.position < 0) {
                return null;
            }
            return MemoClosure.this.reservoir[this.position];
        }

        @Override
        public int position() {
            return this.position + 1;
        }

        @Override
        public void close() {
        }

        @Override
        public SequenceIterator getAnother() {
            return new ProgressiveIterator();
        }

        @Override
        public int getLastPosition() throws XPathException {
            Item item;
            if (MemoClosure.this.state == 3) {
                return MemoClosure.this.used;
            }
            if (MemoClosure.this.state == 5) {
                return 0;
            }
            int savePos = this.position;
            while ((item = this.next()) != null) {
            }
            this.position = savePos;
            return MemoClosure.this.used;
        }

        @Override
        public GroundedValue materialize() throws XPathException {
            if (MemoClosure.this.state == 3) {
                return new SequenceExtent(MemoClosure.this.reservoir);
            }
            if (MemoClosure.this.state == 5) {
                return EmptySequence.getInstance();
            }
            return new SequenceExtent(MemoClosure.this.iterate());
        }

        @Override
        public int getProperties() {
            if (MemoClosure.this.state == 5 || MemoClosure.this.state == 3) {
                return 3;
            }
            return 0;
        }
    }
}

