/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.value;

import net2.sf.saxon.expr.RangeIterator;
import net2.sf.saxon.om.GroundedValue;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.EmptySequence;
import net2.sf.saxon.value.Int64Value;
import net2.sf.saxon.value.Value;

public class IntegerRange
extends Value
implements GroundedValue {
    public long start;
    public long end;

    public IntegerRange(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    @Override
    public SequenceIterator iterate() throws XPathException {
        return new RangeIterator(this.start, this.end);
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.INTEGER;
    }

    @Override
    public int getCardinality() {
        return 32768;
    }

    @Override
    public Item itemAt(int n) {
        if (n < 0 || (long)n > this.end - this.start) {
            return null;
        }
        return Int64Value.makeIntegerValue(this.start + (long)n);
    }

    @Override
    public GroundedValue subsequence(int start, int length) {
        if (length <= 0) {
            return EmptySequence.getInstance();
        }
        long newStart = this.start + (long)(start > 0 ? start : 0);
        long newEnd = newStart + (long)length - 1L;
        if (newEnd > this.end) {
            newEnd = this.end;
        }
        if (newEnd >= newStart) {
            return new IntegerRange(newStart, newEnd);
        }
        return EmptySequence.getInstance();
    }

    @Override
    public int getLength() throws XPathException {
        return (int)(this.end - this.start + 1L);
    }
}

