/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.value;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.AtomicType;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ConversionResult;
import net2.sf.saxon.type.ValidationFailure;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.CalendarValue;
import net2.sf.saxon.value.DateTimeValue;
import net2.sf.saxon.value.DurationValue;
import net2.sf.saxon.value.GDateValue;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.UntypedAtomicValue;
import net2.sf.saxon.value.Whitespace;

public class GMonthDayValue
extends GDateValue {
    private static Pattern regex = Pattern.compile("--([0-9][0-9]-[0-9][0-9])(Z|[+-][0-9][0-9]:[0-9][0-9])?");

    private GMonthDayValue() {
    }

    public static ConversionResult makeGMonthDayValue(CharSequence value) {
        Matcher m = regex.matcher(Whitespace.trimWhitespace(value));
        if (!m.matches()) {
            return new ValidationFailure("Cannot convert '" + value + "' to a gMonthDay");
        }
        GMonthDayValue g = new GMonthDayValue();
        String base = m.group(1);
        String tz = m.group(2);
        String date = "2000-" + base + (tz == null ? "" : tz);
        g.typeLabel = BuiltInAtomicType.G_MONTH_DAY;
        return GMonthDayValue.setLexicalValue(g, date);
    }

    public GMonthDayValue(byte month, byte day, int tz) {
        this(month, day, tz, BuiltInAtomicType.G_MONTH_DAY);
    }

    public GMonthDayValue(byte month, byte day, int tz, AtomicType type) {
        this.year = 2000;
        this.month = month;
        this.day = day;
        this.setTimezoneInMinutes(tz);
        this.typeLabel = type;
    }

    @Override
    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        GMonthDayValue v = new GMonthDayValue(this.month, this.day, this.getTimezoneInMinutes());
        v.typeLabel = typeLabel;
        return v;
    }

    @Override
    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.G_MONTH_DAY;
    }

    @Override
    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        switch (requiredType.getPrimitiveType()) {
            case 524: 
            case 632: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValueCS());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValueCS());
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert gMonthDay to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }

    @Override
    public CharSequence getPrimitiveStringValue() {
        FastStringBuffer sb = new FastStringBuffer(16);
        sb.append("--");
        GMonthDayValue.appendTwoDigits(sb, this.month);
        sb.append('-');
        GMonthDayValue.appendTwoDigits(sb, this.day);
        if (this.hasTimezone()) {
            this.appendTimezone(sb);
        }
        return sb;
    }

    @Override
    public CalendarValue add(DurationValue duration) throws XPathException {
        XPathException err = new XPathException("Cannot add a duration to an xs:gMonthDay");
        err.setErrorCode("XPTY0004");
        throw err;
    }

    @Override
    public CalendarValue adjustTimezone(int tz) {
        DateTimeValue dt = (DateTimeValue)this.toDateTime().adjustTimezone(tz);
        return new GMonthDayValue(dt.getMonth(), dt.getDay(), dt.getTimezoneInMinutes());
    }
}

