/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.type;

import javax.xml.transform.SourceLocator;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ConversionResult;
import net2.sf.saxon.type.ValidationException;
import net2.sf.saxon.value.AtomicValue;
import org.xml.sax.Locator;

public class ValidationFailure
implements SourceLocator,
Locator,
ConversionResult {
    private String message;
    private String systemId;
    private String publicId;
    private int lineNumber = -1;
    private int columnNumber = -1;
    private int schemaPart = -1;
    private String constraintName;
    private String clause;
    private StructuredQName errorCode;

    public ValidationFailure(String message) {
        this.message = message;
    }

    public ValidationFailure(Exception exception) {
        this.message = exception.getMessage();
        if (exception instanceof XPathException) {
            this.errorCode = ((XPathException)exception).getErrorCodeQName();
        }
    }

    public void setConstraintReference(int schemaPart, String constraintName, String clause) {
        this.schemaPart = schemaPart;
        this.constraintName = constraintName;
        this.clause = clause;
    }

    public void setConstraintReference(ValidationFailure e) {
        this.schemaPart = e.schemaPart;
        this.constraintName = e.constraintName;
        this.clause = e.clause;
    }

    public String getConstraintReferenceMessage() {
        if (this.schemaPart == -1) {
            return null;
        }
        return "See http://www.w3.org/TR/xmlschema-" + this.schemaPart + "/#" + this.constraintName + " clause " + this.clause;
    }

    public int getConstraintSchemaPart() {
        return this.schemaPart;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public String getConstraintClauseNumber() {
        return this.clause;
    }

    public String getConstraintReference() {
        return String.valueOf(this.constraintName) + '.' + this.clause;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ValidationException: ");
        String message = this.getMessage();
        if (message != null) {
            sb.append(message);
        }
        return sb.toString();
    }

    @Override
    public String getPublicId() {
        SourceLocator loc = this.getLocator();
        if (this.publicId == null && loc != null && loc != this) {
            return loc.getPublicId();
        }
        return this.publicId;
    }

    @Override
    public String getSystemId() {
        SourceLocator loc = this.getLocator();
        if (this.systemId == null && loc != null && loc != this) {
            return loc.getSystemId();
        }
        return this.systemId;
    }

    @Override
    public int getLineNumber() {
        SourceLocator loc = this.getLocator();
        if (this.lineNumber == -1 && loc != null && loc != this) {
            return loc.getLineNumber();
        }
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        SourceLocator loc = this.getLocator();
        if (this.columnNumber == -1 && loc != null && loc != this) {
            return loc.getColumnNumber();
        }
        return this.columnNumber;
    }

    public void setPublicId(String id) {
        this.publicId = id;
    }

    public void setSystemId(String id) {
        this.systemId = id;
    }

    public void setLineNumber(int line) {
        this.lineNumber = line;
    }

    public void setColumnNumber(int column) {
        this.columnNumber = column;
    }

    public void setLocator(SourceLocator locator) {
        if (locator != null) {
            this.setPublicId(locator.getPublicId());
            this.setSystemId(locator.getSystemId());
            this.setLineNumber(locator.getLineNumber());
            this.setColumnNumber(locator.getColumnNumber());
        }
    }

    public void setSourceLocator(SourceLocator locator) {
        if (locator != null) {
            this.setPublicId(locator.getPublicId());
            this.setSystemId(locator.getSystemId());
            this.setLineNumber(locator.getLineNumber());
            this.setColumnNumber(locator.getColumnNumber());
        }
    }

    public SourceLocator getLocator() {
        return this;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", errorCode);
    }

    public void setErrorCodeQName(StructuredQName errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode == null ? null : this.errorCode.getLocalName();
    }

    public StructuredQName getErrorCodeQName() {
        return this.errorCode;
    }

    public ValidationException makeException() {
        ValidationException ve = new ValidationException(this.message, this.getLocator());
        ve.setConstraintReference(this.schemaPart, this.constraintName, this.clause);
        if (this.errorCode == null) {
            ve.setErrorCode("FORG0001");
        } else {
            ve.setErrorCodeQName(this.errorCode);
        }
        return ve;
    }

    public ValidationException makeException(String contextMessage) {
        ValidationException ve = new ValidationException(contextMessage == null ? this.message : String.valueOf(contextMessage) + this.message);
        ve.setConstraintReference(this.schemaPart, this.constraintName, this.clause);
        if (this.errorCode == null) {
            ve.setErrorCode("FORG0001");
        } else {
            ve.setErrorCodeQName(this.errorCode);
        }
        return ve;
    }

    @Override
    public AtomicValue asAtomic() throws ValidationException {
        throw this.makeException();
    }
}

