/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.type;

import java.io.Serializable;
import net2.sf.saxon.om.FunctionItem;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.StandardNames;
import net2.sf.saxon.pattern.AnyNodeTest;
import net2.sf.saxon.pattern.EmptySequenceTest;
import net2.sf.saxon.pattern.NodeKindTest;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.type.AnyItemType;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.BuiltInType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.SchemaType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.ObjectValue;

public abstract class Type
implements Serializable {
    public static final short ELEMENT = 1;
    public static final short ATTRIBUTE = 2;
    public static final short TEXT = 3;
    public static final short WHITESPACE_TEXT = 4;
    public static final short PROCESSING_INSTRUCTION = 7;
    public static final short COMMENT = 8;
    public static final short DOCUMENT = 9;
    public static final short NAMESPACE = 13;
    public static final short STOPPER = 11;
    public static final short PARENT_POINTER = 12;
    public static final short NODE = 0;
    public static final ItemType NODE_TYPE = AnyNodeTest.getInstance();
    public static final short ITEM = 88;
    public static final ItemType ITEM_TYPE = AnyItemType.getInstance();
    public static final short FUNCTION = 99;
    public static final short MAX_NODE_TYPE = 13;
    public static final short EMPTY = 15;

    private Type() {
    }

    public static boolean isNodeType(ItemType type) {
        return type instanceof NodeTest;
    }

    public static ItemType getItemType(Item item, TypeHierarchy th) {
        if (item instanceof AtomicValue) {
            return ((AtomicValue)item).getItemType(th);
        }
        if (item instanceof NodeInfo) {
            return NodeKindTest.makeNodeKindTest(((NodeInfo)item).getNodeKind());
        }
        return ((FunctionItem)item).getFunctionItemType();
    }

    public static String displayTypeName(Item item) {
        if (item instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)item;
            switch (node.getNodeKind()) {
                case 9: {
                    return "document-node()";
                }
                case 1: {
                    NamePool pool = node.getNamePool();
                    int annotation = node.getTypeAnnotation();
                    return "element(" + ((NodeInfo)item).getDisplayName() + ", " + (annotation == -1 ? "xs:untyped)" : String.valueOf(pool.getDisplayName(annotation)) + ')');
                }
                case 2: {
                    NamePool pool2 = node.getNamePool();
                    int annotation2 = node.getTypeAnnotation() & 0xFFFFF;
                    return "attribute(" + ((NodeInfo)item).getDisplayName() + ", " + (annotation2 == -1 ? "xs:untypedAtomic)" : String.valueOf(pool2.getDisplayName(annotation2)) + ')');
                }
                case 3: {
                    return "text()";
                }
                case 8: {
                    return "comment()";
                }
                case 7: {
                    return "processing-instruction()";
                }
                case 13: {
                    return "namespace()";
                }
            }
            return "";
        }
        if (item instanceof ObjectValue) {
            return ((ObjectValue)item).displayTypeName();
        }
        return ((AtomicValue)item).getItemType(null).toString();
    }

    public static ItemType getBuiltInItemType(String namespace, String localName) {
        SchemaType t = BuiltInType.getSchemaType(StandardNames.getFingerprint(namespace, localName));
        if (t instanceof ItemType) {
            return (ItemType)((Object)t);
        }
        return null;
    }

    public static ItemType getCommonSuperType(ItemType t1, ItemType t2, TypeHierarchy th) {
        if (t1 instanceof EmptySequenceTest) {
            return t2;
        }
        if (t2 instanceof EmptySequenceTest) {
            return t1;
        }
        int r = th.relationship(t1, t2);
        if (r == 0) {
            return t1;
        }
        if (r == 2) {
            return t2;
        }
        if (r == 1) {
            return t1;
        }
        return Type.getCommonSuperType(t2.getSuperType(th), t1, th);
    }

    public static boolean isPrimitiveType(int code) {
        return code >= 0 && (code <= 532 || code == 635 || code == 631 || code == 632 || code == 634 || code == 633 || code == 573);
    }

    public static boolean isComparable(BuiltInAtomicType t1, BuiltInAtomicType t2, boolean ordered) {
        if (t1.equals(BuiltInAtomicType.ANY_ATOMIC) || t2.equals(BuiltInAtomicType.ANY_ATOMIC)) {
            return true;
        }
        if (t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            t1 = BuiltInAtomicType.STRING;
        }
        if (t2.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            t2 = BuiltInAtomicType.STRING;
        }
        if (t1.equals(BuiltInAtomicType.ANY_URI)) {
            t1 = BuiltInAtomicType.STRING;
        }
        if (t2.equals(BuiltInAtomicType.ANY_URI)) {
            t2 = BuiltInAtomicType.STRING;
        }
        if (t1.isPrimitiveNumeric()) {
            t1 = BuiltInAtomicType.NUMERIC;
        }
        if (t2.isPrimitiveNumeric()) {
            t2 = BuiltInAtomicType.NUMERIC;
        }
        if (!ordered) {
            if (t1.equals(BuiltInAtomicType.DAY_TIME_DURATION)) {
                t1 = BuiltInAtomicType.DURATION;
            }
            if (t2.equals(BuiltInAtomicType.DAY_TIME_DURATION)) {
                t2 = BuiltInAtomicType.DURATION;
            }
            if (t1.equals(BuiltInAtomicType.YEAR_MONTH_DURATION)) {
                t1 = BuiltInAtomicType.DURATION;
            }
            if (t2.equals(BuiltInAtomicType.YEAR_MONTH_DURATION)) {
                t2 = BuiltInAtomicType.DURATION;
            }
        }
        return t1 == t2;
    }

    public static boolean isGenerallyComparable(BuiltInAtomicType t1, BuiltInAtomicType t2, boolean ordered) {
        if (t1.equals(BuiltInAtomicType.ANY_ATOMIC) || t2.equals(BuiltInAtomicType.ANY_ATOMIC)) {
            return true;
        }
        if (t1.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            return true;
        }
        if (t2.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            return true;
        }
        if (t1.equals(BuiltInAtomicType.ANY_URI)) {
            t1 = BuiltInAtomicType.STRING;
        }
        if (t2.equals(BuiltInAtomicType.ANY_URI)) {
            t2 = BuiltInAtomicType.STRING;
        }
        if (t1.isPrimitiveNumeric()) {
            t1 = BuiltInAtomicType.NUMERIC;
        }
        if (t2.isPrimitiveNumeric()) {
            t2 = BuiltInAtomicType.NUMERIC;
        }
        if (!ordered) {
            if (t1.equals(BuiltInAtomicType.DAY_TIME_DURATION)) {
                t1 = BuiltInAtomicType.DURATION;
            }
            if (t2.equals(BuiltInAtomicType.DAY_TIME_DURATION)) {
                t2 = BuiltInAtomicType.DURATION;
            }
            if (t1.equals(BuiltInAtomicType.YEAR_MONTH_DURATION)) {
                t1 = BuiltInAtomicType.DURATION;
            }
            if (t2.equals(BuiltInAtomicType.YEAR_MONTH_DURATION)) {
                t2 = BuiltInAtomicType.DURATION;
            }
        }
        return t1 == t2;
    }
}

