/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.type;

import java.io.Serializable;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.StaticContext;
import net2.sf.saxon.instruct.ValueOf;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NameChecker;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.NamespaceResolver;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.AtomicType;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.SchemaException;
import net2.sf.saxon.type.SchemaType;
import net2.sf.saxon.type.SimpleType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.type.ValidationException;
import net2.sf.saxon.type.ValidationFailure;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.ObjectValue;
import net2.sf.saxon.value.Value;

public class ExternalObjectType
implements AtomicType,
Serializable {
    private Class javaClass;
    private Configuration config;
    int fingerprint;
    int baseFingerprint = -1;

    public ExternalObjectType(Class javaClass) {
        this.javaClass = javaClass;
    }

    public ExternalObjectType(Class javaClass, Configuration config) {
        this.javaClass = javaClass;
        this.config = config;
        String localName = javaClass.getName().replace('$', '_');
        this.fingerprint = config.getNamePool().allocate("", "http://saxon.sf.net/java-type", localName);
    }

    @Override
    public String getName() {
        if (this.config == null) {
            return null;
        }
        return this.config.getNamePool().getLocalName(this.fingerprint);
    }

    @Override
    public String getTargetNamespace() {
        if (this.config == null) {
            return null;
        }
        return this.config.getNamePool().getURI(this.fingerprint);
    }

    @Override
    public boolean isExternalType() {
        return true;
    }

    @Override
    public boolean isBuiltInType() {
        return false;
    }

    @Override
    public StructuredQName getTypeName() {
        return null;
    }

    @Override
    public int getRedefinitionLevel() {
        return 0;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isPrimitiveType() {
        return false;
    }

    @Override
    public AtomicType getCommonAtomicType() {
        return this;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public String getSystemId() {
        return null;
    }

    @Override
    public final int getValidationStatus() {
        return 3;
    }

    @Override
    public final int getBlock() {
        return 0;
    }

    @Override
    public final int getDerivationMethod() {
        return 1;
    }

    @Override
    public final boolean allowsDerivation(int derivation) {
        return true;
    }

    @Override
    public int getNameCode() {
        return this.fingerprint;
    }

    @Override
    public final boolean isComplexType() {
        return false;
    }

    @Override
    public final SchemaType getBaseType() {
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    @Override
    public ItemType getPrimitiveItemType() {
        return this;
    }

    @Override
    public int getPrimitiveType() {
        return 632;
    }

    @Override
    public String toString(NamePool pool) {
        return this.getDisplayName();
    }

    @Override
    public AtomicType getAtomizedItemType() {
        return this;
    }

    @Override
    public boolean isAtomizable() {
        return true;
    }

    public SchemaType getKnownBaseType() {
        return this.getBaseType();
    }

    @Override
    public boolean isSameType(SchemaType other) {
        return other.getFingerprint() == this.getFingerprint();
    }

    public int getRelationship(ExternalObjectType other) {
        Class j2 = other.javaClass;
        if (this.javaClass.equals(j2)) {
            return 0;
        }
        if (this.javaClass.isAssignableFrom(j2)) {
            return 1;
        }
        if (j2.isAssignableFrom(this.javaClass)) {
            return 2;
        }
        if (this.javaClass.isInterface() || j2.isInterface()) {
            return 3;
        }
        return 4;
    }

    @Override
    public String getDescription() {
        return this.getDisplayName();
    }

    @Override
    public void checkTypeDerivationIsOK(SchemaType type, int block) throws SchemaException {
    }

    @Override
    public final boolean isSimpleType() {
        return true;
    }

    @Override
    public boolean isAtomicType() {
        return true;
    }

    @Override
    public boolean isIdType() {
        return false;
    }

    @Override
    public boolean isIdRefType() {
        return false;
    }

    @Override
    public boolean isListType() {
        return false;
    }

    @Override
    public boolean isUnionType() {
        return false;
    }

    @Override
    public int getWhitespaceAction(TypeHierarchy th) {
        return 0;
    }

    public CharSequence applyWhitespaceNormalization(CharSequence value) throws ValidationException {
        return value;
    }

    @Override
    public SchemaType getBuiltInBaseType() {
        return this;
    }

    @Override
    public boolean isNamespaceSensitive() {
        return false;
    }

    @Override
    public boolean isAnonymousType() {
        return false;
    }

    @Override
    public final SequenceIterator getTypedValue(NodeInfo node) {
        throw new IllegalStateException("The type annotation of a node cannot be an external object type");
    }

    @Override
    public Value atomize(NodeInfo node) throws XPathException {
        throw new IllegalStateException("The type annotation of a node cannot be an external object type");
    }

    @Override
    public SequenceIterator getTypedValue(CharSequence value, NamespaceResolver resolver, NameChecker nameChecker) throws ValidationException {
        throw new ValidationException("Cannot validate a string against an external object type");
    }

    @Override
    public ValidationFailure validate(AtomicValue primValue, CharSequence lexicalValue, NameChecker checker) {
        throw new UnsupportedOperationException("validate");
    }

    @Override
    public void analyzeContentExpression(Expression expression, int kind, StaticContext env) throws XPathException {
        ExternalObjectType.analyzeContentExpression(this, expression, env, kind);
    }

    public static void analyzeContentExpression(SimpleType simpleType, Expression expression, StaticContext env, int kind) throws XPathException {
        if (kind == 1) {
            expression.checkPermittedContents(simpleType, env, true);
        } else if (kind == 2 && (expression instanceof ValueOf || expression instanceof Literal)) {
            expression.checkPermittedContents(simpleType, env, true);
        }
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    @Override
    public boolean matchesItem(Item item, boolean allowURIPromotion, Configuration config) {
        if (item instanceof ObjectValue) {
            Object obj = ((ObjectValue)item).getObject();
            return this.javaClass.isAssignableFrom(obj.getClass());
        }
        return false;
    }

    @Override
    public ValidationFailure validateContent(CharSequence value, NamespaceResolver nsResolver, NameChecker nameChecker) {
        throw new UnsupportedOperationException("Cannot use an external object type for validation");
    }

    @Override
    public ItemType getSuperType(TypeHierarchy th) {
        if (this.javaClass == Object.class) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        Class javaSuper = this.javaClass.getSuperclass();
        if (javaSuper == null) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        return new ExternalObjectType(javaSuper, this.config);
    }

    @Override
    public int getFingerprint() {
        return this.fingerprint;
    }

    public String toString() {
        String name = this.javaClass.getName();
        name = name.replace('$', '-');
        return "javatype:" + name;
    }

    @Override
    public String getDisplayName() {
        return this.toString();
    }

    public int hashCode() {
        return this.javaClass.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ExternalObjectType && this.javaClass == ((ExternalObjectType)obj).javaClass;
    }

    @Override
    public CharSequence preprocess(CharSequence input) {
        return input;
    }

    @Override
    public CharSequence postprocess(CharSequence input) throws ValidationException {
        return input;
    }
}

