/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.tree;

import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.SingletonIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.tree.NodeImpl;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.Value;

class ProcInstImpl
extends NodeImpl {
    String content;
    int nameCode;
    String systemId;
    int lineNumber = -1;

    public ProcInstImpl(int nameCode, String content) {
        this.nameCode = nameCode;
        this.content = content;
    }

    @Override
    public int getNameCode() {
        return this.nameCode;
    }

    @Override
    public String getStringValue() {
        return this.content;
    }

    @Override
    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator(new StringValue(this.getStringValue()));
    }

    @Override
    public Value atomize() {
        return new StringValue(this.getStringValue());
    }

    @Override
    public final int getNodeKind() {
        return 7;
    }

    public void setLocation(String uri, int lineNumber) {
        this.systemId = uri;
        this.lineNumber = lineNumber;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        out.processingInstruction(this.getLocalPart(), this.content, locationId, 0);
    }

    public String getTarget() {
        return this.getLocalPart();
    }

    public String getData() {
        return this.content;
    }

    @Override
    public void rename(int newNameCode) {
        this.nameCode = newNameCode;
    }

    @Override
    public void replaceStringValue(CharSequence stringValue) {
        this.content = stringValue.toString();
    }
}

