/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.tree;

import java.util.Arrays;

public class LineNumberMap {
    private int[] sequenceNumbers = new int[200];
    private int[] lineNumbers = new int[200];
    private int[] columnNumbers = new int[200];
    private int allocated = 0;

    public void setLineAndColumn(int sequence, int line, int column) {
        if (this.sequenceNumbers.length <= this.allocated + 1) {
            int[] s = new int[this.allocated * 2];
            int[] l = new int[this.allocated * 2];
            int[] c = new int[this.allocated * 2];
            System.arraycopy(this.sequenceNumbers, 0, s, 0, this.allocated);
            System.arraycopy(this.lineNumbers, 0, l, 0, this.allocated);
            System.arraycopy(this.columnNumbers, 0, c, 0, this.allocated);
            this.sequenceNumbers = s;
            this.lineNumbers = l;
            this.columnNumbers = c;
        }
        this.sequenceNumbers[this.allocated] = sequence;
        this.lineNumbers[this.allocated] = line;
        this.columnNumbers[this.allocated] = column;
        ++this.allocated;
    }

    public int getLineNumber(int sequence) {
        int index;
        if (this.sequenceNumbers.length > this.allocated) {
            this.condense();
        }
        if ((index = Arrays.binarySearch(this.sequenceNumbers, sequence)) < 0 && (index = -index - 1) > this.lineNumbers.length - 1) {
            index = this.lineNumbers.length - 1;
        }
        return this.lineNumbers[index];
    }

    public int getColumnNumber(int sequence) {
        int index;
        if (this.sequenceNumbers.length > this.allocated) {
            this.condense();
        }
        if ((index = Arrays.binarySearch(this.sequenceNumbers, sequence)) < 0) {
            index = -index - 1;
        }
        return this.columnNumbers[index];
    }

    private synchronized void condense() {
        int[] s = new int[this.allocated];
        int[] l = new int[this.allocated];
        int[] c = new int[this.allocated];
        System.arraycopy(this.sequenceNumbers, 0, s, 0, this.allocated);
        System.arraycopy(this.lineNumbers, 0, l, 0, this.allocated);
        System.arraycopy(this.columnNumbers, 0, c, 0, this.allocated);
        this.sequenceNumbers = s;
        this.lineNumbers = l;
        this.columnNumbers = c;
    }
}

