/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.tree;

import net2.sf.saxon.om.AttributeCollection;
import net2.sf.saxon.om.AttributeCollectionImpl;
import net2.sf.saxon.om.AxisIteratorImpl;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.LookaheadIterator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.pattern.NameTest;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.tree.AttributeImpl;
import net2.sf.saxon.tree.ElementImpl;
import net2.sf.saxon.tree.NodeImpl;

final class AttributeEnumeration
extends AxisIteratorImpl
implements LookaheadIterator {
    private ElementImpl element;
    private AttributeCollectionImpl attributes;
    private NodeTest nodeTest;
    private NodeInfo next;
    private int index;
    private int length;

    public AttributeEnumeration(NodeImpl node, NodeTest nodeTest) {
        this.nodeTest = nodeTest;
        if (node.getNodeKind() == 1) {
            this.element = (ElementImpl)node;
            this.attributes = (AttributeCollectionImpl)this.element.getAttributeList();
            AttributeCollection attlist = this.element.getAttributeList();
            this.index = 0;
            if (nodeTest instanceof NameTest) {
                NameTest test = (NameTest)nodeTest;
                this.index = attlist.getIndexByFingerprint(test.getFingerprint());
                if (this.index < 0) {
                    this.next = null;
                } else {
                    this.next = new AttributeImpl(this.element, this.index);
                    this.index = 0;
                    this.length = 0;
                }
            } else {
                this.index = 0;
                this.length = attlist.getLength();
                this.advance();
            }
        } else {
            this.next = null;
            this.index = 0;
            this.length = 0;
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Item next() {
        if (this.next == null) {
            this.current = null;
            this.position = -1;
            return null;
        }
        this.current = this.next;
        ++this.position;
        this.advance();
        return this.current;
    }

    private void advance() {
        while (true) {
            if (this.index >= this.length) {
                this.next = null;
                return;
            }
            if (this.attributes.isDeleted(this.index)) {
                ++this.index;
                continue;
            }
            this.next = new AttributeImpl(this.element, this.index);
            ++this.index;
            if (this.nodeTest.matches(this.next)) break;
        }
    }

    @Override
    public SequenceIterator getAnother() {
        return new AttributeEnumeration(this.element, this.nodeTest);
    }

    @Override
    public int getProperties() {
        return 4;
    }
}

