/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.trans;

import java.io.Serializable;
import java.util.ArrayList;
import net2.sf.saxon.expr.Optimizer;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.expr.XPathContextMajor;
import net2.sf.saxon.instruct.Template;
import net2.sf.saxon.om.Navigator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.pattern.AnyNodeTest;
import net2.sf.saxon.pattern.EmptySequenceTest;
import net2.sf.saxon.pattern.NameTest;
import net2.sf.saxon.pattern.NodeKindTest;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.pattern.NodeTestPattern;
import net2.sf.saxon.pattern.Pattern;
import net2.sf.saxon.sort.GenericSorter;
import net2.sf.saxon.sort.IntHashMap;
import net2.sf.saxon.sort.IntIterator;
import net2.sf.saxon.sort.Sortable;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.Rule;
import net2.sf.saxon.trans.RuleTarget;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.Whitespace;

public class Mode
implements Serializable {
    public static final int DEFAULT_MODE = -1;
    public static final int NAMED_MODE = -3;
    public static final int STRIPPER_MODE = -4;
    public static final StructuredQName ALL_MODES = new StructuredQName("saxon", "http://saxon.sf.net/", "_omniMode");
    public static final StructuredQName DEFAULT_MODE_NAME = new StructuredQName("saxon", "http://saxon.sf.net/", "_defaultMode");
    private Rule genericNodeRuleChain = null;
    private Rule documentRuleChain = null;
    private Rule textRuleChain = null;
    private Rule commentRuleChain = null;
    private Rule processingInstructionRuleChain = null;
    private Rule namespaceRuleChain = null;
    private Rule unnamedElementRuleChain = null;
    private Rule unnamedAttributeRuleChain = null;
    private IntHashMap<Rule> namedElementRuleChains = new IntHashMap(32);
    private IntHashMap<Rule> namedAttributeRuleChains = new IntHashMap(8);
    private Rule mostRecentRule;
    private boolean isDefault;
    private boolean streamable;
    private boolean isStripper;
    private boolean hasRules = false;
    private StructuredQName modeName;
    private int stackFrameSlotsNeeded = 0;
    private int recoveryPolicy = 1;

    public Mode(int usage, StructuredQName modeName) {
        this.isDefault = usage == -1;
        this.isStripper = usage == -4;
        this.modeName = modeName;
    }

    public Mode(Mode omniMode, StructuredQName modeName) {
        this.isDefault = false;
        this.isStripper = false;
        this.modeName = modeName;
        if (omniMode != null) {
            Rule r;
            int fp;
            this.documentRuleChain = omniMode.documentRuleChain == null ? null : new Rule(omniMode.documentRuleChain);
            this.textRuleChain = omniMode.textRuleChain == null ? null : new Rule(omniMode.textRuleChain);
            this.commentRuleChain = omniMode.commentRuleChain == null ? null : new Rule(omniMode.commentRuleChain);
            this.processingInstructionRuleChain = omniMode.processingInstructionRuleChain == null ? null : new Rule(omniMode.processingInstructionRuleChain);
            this.namespaceRuleChain = omniMode.namespaceRuleChain == null ? null : new Rule(omniMode.namespaceRuleChain);
            this.unnamedElementRuleChain = omniMode.unnamedElementRuleChain == null ? null : new Rule(omniMode.unnamedElementRuleChain);
            this.unnamedAttributeRuleChain = omniMode.unnamedAttributeRuleChain == null ? null : new Rule(omniMode.unnamedAttributeRuleChain);
            this.namedElementRuleChains = new IntHashMap(omniMode.namedElementRuleChains.size());
            IntIterator ii = omniMode.namedElementRuleChains.keyIterator();
            while (ii.hasNext()) {
                fp = ii.next();
                r = omniMode.namedElementRuleChains.get(fp);
                this.namedElementRuleChains.put(fp, new Rule(r));
            }
            ii = omniMode.namedAttributeRuleChains.keyIterator();
            while (ii.hasNext()) {
                fp = ii.next();
                r = omniMode.namedAttributeRuleChains.get(fp);
                this.namedAttributeRuleChains.put(fp, new Rule(r));
            }
            this.mostRecentRule = omniMode.mostRecentRule;
        }
    }

    public boolean isDefaultMode() {
        return this.isDefault;
    }

    public StructuredQName getModeName() {
        return this.modeName;
    }

    public boolean isEmpty() {
        return !this.hasRules;
    }

    public void setRecoveryPolicy(int policy) {
        this.recoveryPolicy = policy;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void setStreamable(boolean streamable) throws XPathException {
        this.streamable = streamable;
    }

    public boolean isStreamable() {
        return this.streamable;
    }

    public void addRule(Pattern pattern, RuleTarget action, int precedence, double priority, boolean explicitMode) {
        if (explicitMode) {
            this.hasRules = true;
        }
        if (pattern.getNodeTest() instanceof EmptySequenceTest) {
            return;
        }
        int sequence = this.mostRecentRule == null ? 0 : (action == this.mostRecentRule.getAction() ? this.mostRecentRule.getSequence() : this.mostRecentRule.getSequence() + 1);
        Rule newRule = new Rule(pattern, action, precedence, priority, sequence);
        if (pattern instanceof NodeTestPattern) {
            int kind;
            NodeTest test = pattern.getNodeTest();
            if (test instanceof AnyNodeTest) {
                newRule.setAlwaysMatches(true);
            } else if (test instanceof NodeKindTest) {
                newRule.setAlwaysMatches(true);
            } else if (test instanceof NameTest && ((kind = test.getPrimitiveType()) == 1 || kind == 2)) {
                newRule.setAlwaysMatches(true);
            }
        }
        this.mostRecentRule = newRule;
        int kind = pattern.getNodeKind();
        switch (kind) {
            case 1: {
                int fp = pattern.getFingerprint();
                if (fp == -1) {
                    this.unnamedElementRuleChain = this.addRuleToList(newRule, this.unnamedElementRuleChain);
                    break;
                }
                Rule chain = this.namedElementRuleChains.get(fp);
                this.namedElementRuleChains.put(fp, this.addRuleToList(newRule, chain));
                break;
            }
            case 2: {
                int fp = pattern.getFingerprint();
                if (fp == -1) {
                    this.unnamedAttributeRuleChain = this.addRuleToList(newRule, this.unnamedAttributeRuleChain);
                    break;
                }
                Rule chain = this.namedAttributeRuleChains.get(fp);
                this.namedAttributeRuleChains.put(fp, this.addRuleToList(newRule, chain));
                break;
            }
            case 0: {
                this.genericNodeRuleChain = this.addRuleToList(newRule, this.genericNodeRuleChain);
                break;
            }
            case 9: {
                this.documentRuleChain = this.addRuleToList(newRule, this.documentRuleChain);
                break;
            }
            case 3: {
                this.textRuleChain = this.addRuleToList(newRule, this.textRuleChain);
                break;
            }
            case 8: {
                this.commentRuleChain = this.addRuleToList(newRule, this.commentRuleChain);
                break;
            }
            case 7: {
                this.processingInstructionRuleChain = this.addRuleToList(newRule, this.processingInstructionRuleChain);
                break;
            }
            case 13: {
                this.namespaceRuleChain = this.addRuleToList(newRule, this.namespaceRuleChain);
            }
        }
    }

    private Rule addRuleToList(Rule newRule, Rule list) {
        if (list == null) {
            return newRule;
        }
        int precedence = newRule.getPrecedence();
        double priority = newRule.getPriority();
        Rule rule = list;
        Rule prev = null;
        while (rule != null) {
            if (rule.getPrecedence() < precedence || rule.getPrecedence() == precedence && rule.getPriority() <= priority) {
                newRule.setNext(rule);
                if (prev == null) {
                    return newRule;
                }
                prev.setNext(newRule);
                break;
            }
            prev = rule;
            rule = rule.getNext();
        }
        if (rule == null) {
            prev.setNext(newRule);
            newRule.setNext(null);
        }
        return list;
    }

    public void allocatePatternSlots(int slots) {
        this.stackFrameSlotsNeeded = Math.max(this.stackFrameSlotsNeeded, slots);
    }

    private XPathContext makeNewContext(XPathContext context) {
        context = context.newContext();
        context.setOriginatingConstructType(2000);
        ((XPathContextMajor)context).openStackFrame(this.stackFrameSlotsNeeded);
        return context;
    }

    public Rule getRule(NodeInfo node, XPathContext context) throws XPathException {
        Rule unnamedNodeChain;
        if (this.stackFrameSlotsNeeded > 0) {
            context = this.makeNewContext(context);
        }
        Rule bestRule = null;
        switch (node.getNodeKind()) {
            case 9: {
                unnamedNodeChain = this.documentRuleChain;
                break;
            }
            case 1: {
                unnamedNodeChain = this.unnamedElementRuleChain;
                Rule namedNodeChain = this.namedElementRuleChains.get(node.getFingerprint());
                if (namedNodeChain == null) break;
                bestRule = this.searchRuleChain(node, context, null, namedNodeChain);
                break;
            }
            case 2: {
                unnamedNodeChain = this.unnamedAttributeRuleChain;
                Rule namedNodeChain = this.namedAttributeRuleChains.get(node.getFingerprint());
                if (namedNodeChain == null) break;
                bestRule = this.searchRuleChain(node, context, null, namedNodeChain);
                break;
            }
            case 3: {
                unnamedNodeChain = this.textRuleChain;
                break;
            }
            case 8: {
                unnamedNodeChain = this.commentRuleChain;
                break;
            }
            case 7: {
                unnamedNodeChain = this.processingInstructionRuleChain;
                break;
            }
            case 13: {
                unnamedNodeChain = this.namespaceRuleChain;
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown node kind");
            }
        }
        if (unnamedNodeChain != null) {
            bestRule = this.searchRuleChain(node, context, bestRule, unnamedNodeChain);
        }
        if (this.genericNodeRuleChain != null) {
            bestRule = this.searchRuleChain(node, context, bestRule, this.genericNodeRuleChain);
        }
        return bestRule;
    }

    private Rule searchRuleChain(NodeInfo node, XPathContext context, Rule bestRule, Rule head) throws XPathException {
        while (head != null) {
            if (bestRule != null) {
                int rank = head.compareRank(bestRule);
                if (rank < 0) break;
                if (rank == 0) {
                    if (head.isAlwaysMatches() || head.getPattern().matches(node, context)) {
                        this.reportAmbiguity(node, bestRule, head, context);
                        bestRule = bestRule.getSequence() > head.getSequence() ? bestRule : head;
                        break;
                    }
                } else if (head.isAlwaysMatches() || head.getPattern().matches(node, context)) {
                    bestRule = head;
                }
            } else if (head.isAlwaysMatches() || head.getPattern().matches(node, context)) {
                bestRule = head;
                if (this.recoveryPolicy == 0) break;
            }
            head = head.getNext();
        }
        return bestRule;
    }

    public Rule getRule(NodeInfo node, XPathContext context, RuleFilter filter) throws XPathException {
        Rule unnamedNodeChain;
        if (this.stackFrameSlotsNeeded > 0) {
            context = this.makeNewContext(context);
        }
        Rule bestRule = null;
        switch (node.getNodeKind()) {
            case 9: {
                unnamedNodeChain = this.documentRuleChain;
                break;
            }
            case 1: {
                unnamedNodeChain = this.unnamedElementRuleChain;
                Rule namedNodeChain = this.namedElementRuleChains.get(node.getFingerprint());
                bestRule = this.searchRuleChain(node, context, null, namedNodeChain, filter);
                break;
            }
            case 2: {
                unnamedNodeChain = this.unnamedAttributeRuleChain;
                Rule namedNodeChain = this.namedAttributeRuleChains.get(node.getFingerprint());
                bestRule = this.searchRuleChain(node, context, null, namedNodeChain, filter);
                break;
            }
            case 3: {
                unnamedNodeChain = this.textRuleChain;
                break;
            }
            case 8: {
                unnamedNodeChain = this.commentRuleChain;
                break;
            }
            case 7: {
                unnamedNodeChain = this.processingInstructionRuleChain;
                break;
            }
            case 13: {
                unnamedNodeChain = this.namespaceRuleChain;
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown node kind");
            }
        }
        bestRule = this.searchRuleChain(node, context, bestRule, unnamedNodeChain, filter);
        return this.searchRuleChain(node, context, bestRule, this.genericNodeRuleChain, filter);
    }

    private Rule searchRuleChain(NodeInfo node, XPathContext context, Rule bestRule, Rule head, RuleFilter filter) throws XPathException {
        while (head != null) {
            if (filter.testRule(head)) {
                if (bestRule != null) {
                    int rank = head.compareRank(bestRule);
                    if (rank < 0) break;
                    if (rank == 0) {
                        if (head.isAlwaysMatches() || head.getPattern().matches(node, context)) {
                            this.reportAmbiguity(node, bestRule, head, context);
                            bestRule = bestRule.getSequence() > head.getSequence() ? bestRule : head;
                            break;
                        }
                    } else if (head.isAlwaysMatches() || head.getPattern().matches(node, context)) {
                        bestRule = head;
                    }
                } else if (head.isAlwaysMatches() || head.getPattern().matches(node, context)) {
                    bestRule = head;
                    if (this.recoveryPolicy == 0) break;
                }
            }
            head = head.getNext();
        }
        return bestRule;
    }

    public Rule getRule(NodeInfo node, final int min, final int max, XPathContext context) throws XPathException {
        RuleFilter filter = new RuleFilter(){

            @Override
            public boolean testRule(Rule r) {
                int p = r.getPrecedence();
                return p >= min && p <= max;
            }
        };
        return this.getRule(node, context, filter);
    }

    public Rule getNextMatchRule(NodeInfo node, final Rule currentRule, XPathContext context) throws XPathException {
        RuleFilter filter = new RuleFilter(){

            @Override
            public boolean testRule(Rule r) {
                int comp = r.compareRank(currentRule);
                return comp < 0 || comp == 0 && r.getSequence() < currentRule.getSequence();
            }
        };
        return this.getRule(node, context, filter);
    }

    private void reportAmbiguity(NodeInfo node, Rule r1, Rule r2, XPathContext c) throws XPathException {
        String path;
        if (r1.getAction() == r2.getAction()) {
            return;
        }
        String errorCode = "XTRE0540";
        if (this.isStripper) {
            if (r1.getAction().equals(r2.getAction())) {
                return;
            }
            errorCode = "XTRE0270";
            path = "xsl:strip-space";
        } else {
            path = Navigator.getPath(node);
        }
        Pattern pat1 = r1.getPattern();
        Pattern pat2 = r2.getPattern();
        XPathException err = new XPathException("Ambiguous rule match for " + path + '\n' + "Matches both \"" + Mode.showPattern(pat1) + "\" on line " + pat1.getLineNumber() + " of " + pat1.getSystemId() + "\nand \"" + Mode.showPattern(pat2) + "\" on line " + pat2.getLineNumber() + " of " + pat2.getSystemId());
        err.setErrorCode(errorCode);
        c.getController().recoverableError(err);
    }

    private static String showPattern(Pattern p) {
        return Whitespace.collapseWhitespace(p.toString()).toString();
    }

    public void processRules(RuleAction action) throws XPathException {
        Rule r;
        this.processRuleChain(this.documentRuleChain, action);
        this.processRuleChain(this.unnamedElementRuleChain, action);
        IntIterator ii = this.namedElementRuleChains.keyIterator();
        while (ii.hasNext()) {
            r = this.namedElementRuleChains.get(ii.next());
            this.processRuleChain(r, action);
        }
        this.processRuleChain(this.unnamedAttributeRuleChain, action);
        ii = this.namedAttributeRuleChains.keyIterator();
        while (ii.hasNext()) {
            r = this.namedAttributeRuleChains.get(ii.next());
            this.processRuleChain(r, action);
        }
        this.processRuleChain(this.textRuleChain, action);
        this.processRuleChain(this.commentRuleChain, action);
        this.processRuleChain(this.processingInstructionRuleChain, action);
        this.processRuleChain(this.namespaceRuleChain, action);
        this.processRuleChain(this.genericNodeRuleChain, action);
    }

    private void processRuleChain(Rule r, RuleAction action) throws XPathException {
        while (r != null) {
            action.processRule(r);
            r = r.getNext();
        }
    }

    public void invertStreamableTemplates(final Optimizer opt) throws XPathException {
        if (this.streamable) {
            RuleAction action = new RuleAction(){

                @Override
                public void processRule(Rule r) throws XPathException {
                    NodeTest test = r.getPattern().getNodeTest();
                    int kind = test.getPrimitiveType();
                    if (kind == 9 || kind == 1) {
                        Template t = (Template)r.getAction();
                        RuleTarget inverse = opt.makeInversion(t, test);
                        r.setAction(inverse);
                    }
                }
            };
            this.processRules(action);
        }
    }

    public void explainTemplateRules(final ExpressionPresenter presenter) {
        RuleAction action = new RuleAction(){

            @Override
            public void processRule(Rule r) {
                RuleTarget t = r.getAction();
                int s = presenter.startElement("templateRule");
                presenter.emitAttribute("match", r.getPattern().toString());
                presenter.emitAttribute("precedence", String.valueOf(r.getPrecedence()));
                presenter.emitAttribute("priority", String.valueOf(r.getPriority()));
                t.explain(presenter);
                int e = presenter.endElement();
                if (s != e) {
                    throw new IllegalStateException("tree unbalanced in template at line " + (t instanceof Template ? String.valueOf(((Template)t).getLineNumber()) + " of " + ((Template)t).getSystemId() : ""));
                }
            }
        };
        try {
            this.processRules(action);
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
    }

    public void computeRankings() throws XPathException {
        final RuleSorter sorter = new RuleSorter();
        RuleAction addToSorter = new RuleAction(){

            @Override
            public void processRule(Rule r) {
                sorter.addRule(r);
            }
        };
        this.processRules(addToSorter);
        sorter.allocateRanks();
    }

    private static interface RuleAction {
        public void processRule(Rule var1) throws XPathException;
    }

    private static interface RuleFilter {
        public boolean testRule(Rule var1);
    }

    private static class RuleSorter
    implements Sortable {
        public ArrayList<Rule> rules = new ArrayList(100);

        private RuleSorter() {
        }

        public void addRule(Rule rule) {
            this.rules.add(rule);
        }

        @Override
        public int compare(int a, int b) {
            return this.rules.get(a).compareComputedRank(this.rules.get(b));
        }

        @Override
        public void swap(int a, int b) {
            Rule temp = this.rules.get(a);
            this.rules.set(a, this.rules.get(b));
            this.rules.set(b, temp);
        }

        public void allocateRanks() {
            GenericSorter.quickSort(0, this.rules.size(), this);
            int rank = 0;
            int i = 0;
            while (i < this.rules.size()) {
                if (i > 0 && this.rules.get(i - 1).compareComputedRank(this.rules.get(i)) != 0) {
                    ++rank;
                }
                this.rules.get(i).setRank(rank);
                ++i;
            }
        }
    }
}

