/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.trans;

import java.io.Serializable;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.SequenceIterable;
import net2.sf.saxon.instruct.Procedure;
import net2.sf.saxon.instruct.SlotManager;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.pattern.PatternFinder;
import net2.sf.saxon.sort.StringCollator;
import net2.sf.saxon.type.BuiltInAtomicType;

public class KeyDefinition
extends Procedure
implements Serializable {
    private PatternFinder match;
    private SequenceIterable use;
    private BuiltInAtomicType useType;
    private StringCollator collation;
    private String collationName;
    private boolean backwardsCompatible = false;
    private boolean strictComparison = false;
    private boolean convertUntypedToOther = false;

    public KeyDefinition(PatternFinder match, SequenceIterable use, String collationName, StringCollator collation) {
        this.setHostLanguage(50);
        this.match = match;
        this.use = use;
        if (use instanceof Expression) {
            this.setBody((Expression)use);
        }
        this.collation = collation;
        this.collationName = collationName;
    }

    public void setIndexedItemType(BuiltInAtomicType itemType) {
        this.useType = itemType;
    }

    public BuiltInAtomicType getIndexedItemType() {
        if (this.useType == null) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        return this.useType;
    }

    public void setBackwardsCompatible(boolean bc) {
        this.backwardsCompatible = bc;
    }

    public boolean isBackwardsCompatible() {
        return this.backwardsCompatible;
    }

    public void setStrictComparison(boolean strict) {
        this.strictComparison = strict;
    }

    public boolean isStrictComparison() {
        return this.strictComparison;
    }

    public void setConvertUntypedToOther(boolean convertToOther) {
        this.convertUntypedToOther = convertToOther;
    }

    public boolean isConvertUntypedToOther() {
        return this.convertUntypedToOther;
    }

    @Override
    public void setStackFrameMap(SlotManager map) {
        if (map != null && map.getNumberOfVariables() > 0) {
            super.setStackFrameMap(map);
        }
    }

    public void setLocation(String systemId, int lineNumber) {
        this.setSystemId(systemId);
        this.setLineNumber(lineNumber);
    }

    public PatternFinder getMatch() {
        return this.match;
    }

    @Override
    public void setBody(Expression body) {
        super.setBody(body);
        this.use = body;
    }

    public SequenceIterable getUse() {
        return this.use;
    }

    public String getCollationName() {
        return this.collationName;
    }

    public StringCollator getCollation() {
        return this.collation;
    }

    @Override
    public int getConstructType() {
        return 154;
    }

    @Override
    public StructuredQName getObjectName() {
        return null;
    }
}

