/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.trace;

import java.io.PrintStream;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.trace.InstructionInfo;
import net2.sf.saxon.trace.TraceListener;

public class TimedTraceListener
implements TraceListener {
    PrintStream out = System.err;

    public void setOutputStream(PrintStream stream) {
        this.out = stream;
    }

    @Override
    public void open() {
        this.out.println("<trace time=\"" + System.currentTimeMillis() + "\">");
    }

    @Override
    public void close() {
        this.out.println("<end time=\"" + System.currentTimeMillis() + "\"/></trace>");
    }

    @Override
    public void enter(InstructionInfo instruction, XPathContext context) {
        int loc = instruction.getConstructType();
        if (loc == 149 || loc == 181) {
            String file;
            String tag = "<";
            tag = String.valueOf(tag) + (loc == 149 ? "function" : "template");
            String name = null;
            if (instruction.getObjectName() != null) {
                name = instruction.getObjectName().getDisplayName();
            } else if (instruction.getProperty("name") != null) {
                name = instruction.getProperty("name").toString();
            }
            if (name != null) {
                tag = String.valueOf(tag) + " name=\"" + name + "\"";
            }
            if (instruction.getProperty("match") != null) {
                tag = String.valueOf(tag) + " match=\"" + instruction.getProperty("match") + "\"";
            }
            if ((file = instruction.getSystemId()) != null) {
                if (file.length() > 15) {
                    file = "*" + file.substring(file.length() - 14);
                }
                tag = String.valueOf(tag) + " file=\"" + file + "\"";
            }
            tag = String.valueOf(tag) + " line=\"" + instruction.getLineNumber() + "\"";
            tag = String.valueOf(tag) + " time=\"" + System.currentTimeMillis() + "\"";
            tag = String.valueOf(tag) + ">";
            this.out.println(tag);
        }
    }

    @Override
    public void leave(InstructionInfo instruction) {
        int loc = instruction.getConstructType();
        if (loc == 149 || loc == 181) {
            String tag = "<end time=\"" + System.currentTimeMillis() + "\"/></";
            tag = String.valueOf(tag) + (loc == 149 ? "function>" : "template>");
            this.out.println(tag);
        }
    }

    @Override
    public void startCurrentItem(Item item) {
    }

    @Override
    public void endCurrentItem(Item item) {
    }
}

