/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.tinytree;

import net2.sf.saxon.Configuration;
import net2.sf.saxon.event.CopyNamespaceSensitiveException;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.om.NamespaceCodeIterator;
import net2.sf.saxon.om.NamespaceResolver;
import net2.sf.saxon.om.Navigator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.tinytree.TinyParentNodeImpl;
import net2.sf.saxon.tinytree.TinyTextImpl;
import net2.sf.saxon.tinytree.TinyTree;
import net2.sf.saxon.tinytree.WhitespaceTextImpl;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.SchemaType;
import net2.sf.saxon.type.SimpleType;
import net2.sf.saxon.value.Value;

public final class TinyElementImpl
extends TinyParentNodeImpl {
    public TinyElementImpl(TinyTree tree, int nodeNr) {
        this.tree = tree;
        this.nodeNr = nodeNr;
    }

    @Override
    public final int getNodeKind() {
        return 1;
    }

    @Override
    public String getBaseURI() {
        return Navigator.getBaseURI(this);
    }

    @Override
    public int getTypeAnnotation() {
        return this.tree.getTypeAnnotation(this.nodeNr);
    }

    @Override
    public SequenceIterator getTypedValue() throws XPathException {
        return this.tree.getTypedValueOfElement(this).iterate();
    }

    @Override
    public Value atomize() throws XPathException {
        return this.tree.getTypedValueOfElement(this);
    }

    @Override
    public int[] getDeclaredNamespaces(int[] buffer) {
        return TinyElementImpl.getDeclaredNamespaces(this.tree, this.nodeNr, buffer);
    }

    public static int[] getDeclaredNamespaces(TinyTree tree, int nodeNr, int[] buffer) {
        int ns = tree.beta[nodeNr];
        if (ns > 0) {
            int count = 0;
            while (ns < tree.numberOfNamespaces && tree.namespaceParent[ns] == nodeNr) {
                ++count;
                ++ns;
            }
            if (count == 0) {
                return NodeInfo.EMPTY_NAMESPACE_LIST;
            }
            if (buffer != null && count <= buffer.length) {
                System.arraycopy(tree.namespaceCode, tree.beta[nodeNr], buffer, 0, count);
                if (count < buffer.length) {
                    buffer[count] = -1;
                }
                return buffer;
            }
            int[] array = new int[count];
            System.arraycopy(tree.namespaceCode, tree.beta[nodeNr], array, 0, count);
            return array;
        }
        return NodeInfo.EMPTY_NAMESPACE_LIST;
    }

    public static int[] getInScopeNamespaces(TinyTree tree, int nodeNr, int[] buffer) {
        if (buffer == null || buffer.length == 0) {
            buffer = new int[10];
        }
        buffer[0] = 65537;
        int used = 1;
        if (tree.usesNamespaces) {
            do {
                int ns;
                if ((ns = tree.beta[nodeNr]) <= 0) continue;
                while (ns < tree.numberOfNamespaces && tree.namespaceParent[ns] == nodeNr) {
                    int nscode = tree.namespaceCode[ns];
                    short prefixCode = (short)(nscode >> 16);
                    boolean duplicate = false;
                    int i = 0;
                    while (i < used) {
                        if (buffer[i] >> 16 == prefixCode) {
                            duplicate = true;
                            break;
                        }
                        ++i;
                    }
                    if (!duplicate) {
                        if (used >= buffer.length) {
                            int[] b2 = new int[used * 2];
                            System.arraycopy(buffer, 0, b2, 0, used);
                            buffer = b2;
                        }
                        buffer[used++] = nscode;
                    }
                    ++ns;
                }
            } while ((nodeNr = TinyElementImpl.getParentNodeNr(tree, nodeNr)) != -1);
            int j = 0;
            int i = 0;
            while (i < used) {
                int nscode = buffer[i];
                if ((nscode & 0xFFFF) != 0) {
                    buffer[j++] = nscode;
                }
                ++i;
            }
            used = j;
        }
        if (used < buffer.length) {
            buffer[used] = -1;
        }
        return buffer;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String getAttributeValue(int fingerprint) {
        a = this.tree.alpha[this.nodeNr];
        if (a >= 0) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            if ((this.tree.attCode[a] & 1048575) == fingerprint) {
                return this.tree.attValue[a].toString();
            }
            ++a;
lbl7:
            // 2 sources

            ** while (a < this.tree.numberOfAttributes && this.tree.attParent[a] == this.nodeNr)
        }
lbl8:
        // 1 sources

        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void copy(Receiver receiver, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        level = -1;
        closePending = false;
        startLevel = this.tree.depth[this.nodeNr];
        first = true;
        disallowNamespaceSensitiveContent = whichNamespaces == 0 && copyAnnotations != false;
        config = this.tree.getConfiguration();
        next = this.nodeNr;
        informee = receiver.getPipelineConfiguration().getCopyInformee();
        do {
            nodeLevel = this.tree.depth[next];
            if (closePending) {
                level = (short)(level + 1);
            }
            while (level > nodeLevel) {
                receiver.endElement();
                level = (short)(level - 1);
            }
            level = nodeLevel;
            switch (this.tree.nodeKind[next]) {
                case 1: {
                    v0 = typeCode = copyAnnotations != false ? this.tree.getTypeAnnotation(next) : 630;
                    if (disallowNamespaceSensitiveContent) {
                        this.checkNotNamespaceSensitive(config, typeCode);
                    }
                    if (informee != null) {
                        locationId = informee.notifyElementNode(this.tree.getNode(next));
                    }
                    nameCode = this.tree.nameCode[next];
                    receiver.startElement(nameCode, typeCode, locationId, first != false ? 0 : 64);
                    closePending = true;
                    if (whichNamespaces == 0 || !this.tree.usesNamespaces) ** GOTO lbl54
                    if (!first) ** GOTO lbl47
                    switch (whichNamespaces) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            localNamespaces = this.getDeclaredNamespaces(null);
                            i = 0;
                            while (i < localNamespaces.length) {
                                ns = localNamespaces[i];
                                if (ns != -1) {
                                    receiver.namespace(ns, 0);
                                    ++i;
                                    continue;
                                }
                                ** GOTO lbl54
                            }
                            ** GOTO lbl54
                        }
                        case 2: {
                            NamespaceCodeIterator.sendNamespaces(this, receiver);
                        }
                    }
                    ** GOTO lbl54
lbl47:
                    // 1 sources

                    ns = this.tree.beta[next];
                    if (ns > 0) {
                        while (ns < this.tree.numberOfNamespaces && this.tree.namespaceParent[ns] == next) {
                            nscode = this.tree.namespaceCode[ns];
                            receiver.namespace(nscode, 0);
                            ++ns;
                        }
                    }
lbl54:
                    // 7 sources

                    first = false;
                    att = this.tree.alpha[next];
                    if (att >= 0) {
                        while (att < this.tree.numberOfAttributes && this.tree.attParent[att] == next) {
                            attCode = this.tree.attCode[att];
                            v1 = attType = copyAnnotations != false ? this.tree.getAttributeAnnotation(att) : 631;
                            if (disallowNamespaceSensitiveContent) {
                                this.checkNotNamespaceSensitive(config, attType);
                            }
                            receiver.attribute(attCode, attType, this.tree.attValue[att], locationId, 0);
                            ++att;
                        }
                    }
                    receiver.startContent();
                    break;
                }
                case 3: {
                    closePending = false;
                    value = TinyTextImpl.getStringValue(this.tree, next);
                    receiver.characters(value, locationId, 1024);
                    break;
                }
                case 4: {
                    closePending = false;
                    value = WhitespaceTextImpl.getStringValueCS(this.tree, next);
                    receiver.characters(value, locationId, 1024);
                    break;
                }
                case 8: {
                    closePending = false;
                    start = this.tree.alpha[next];
                    len = this.tree.beta[next];
                    if (len > 0) {
                        receiver.comment(this.tree.commentBuffer.subSequence(start, start + len), locationId, 0);
                        break;
                    }
                    receiver.comment("", 0, 0);
                    break;
                }
                case 7: {
                    closePending = false;
                    pi = this.tree.getNode(next);
                    receiver.processingInstruction(pi.getLocalPart(), pi.getStringValue(), locationId, 0);
                    break;
                }
                case 12: {
                    closePending = false;
                }
            }
        } while (++next < this.tree.numberOfNodes && this.tree.depth[next] > startLevel);
        if (closePending) {
            level = (short)(level + 1);
        }
        while (level > startLevel) {
            receiver.endElement();
            level = (short)(level - 1);
        }
    }

    private void checkNotNamespaceSensitive(Configuration config, int typeCode) throws XPathException {
        SchemaType type = config.getSchemaType(typeCode & 0xFFFFF);
        if (type instanceof SimpleType && ((SimpleType)type).isNamespaceSensitive()) {
            throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
        }
    }

    public String getURIForPrefix(String prefix, boolean useDefault) {
        NodeInfo parent;
        if (!(useDefault || prefix != null && prefix.length() != 0)) {
            return "";
        }
        short prefixCode = this.getNamePool().getCodeForPrefix(prefix);
        if (prefixCode == -1) {
            return null;
        }
        int ns = this.tree.beta[this.nodeNr];
        if (ns > 0) {
            while (ns < this.tree.numberOfNamespaces && this.tree.namespaceParent[ns] == this.nodeNr) {
                int nscode = this.tree.namespaceCode[ns];
                if (nscode >> 16 == prefixCode) {
                    int uriCode = nscode & 0xFFFF;
                    if (uriCode == 0) {
                        if (prefixCode == 0) {
                            return "";
                        }
                        return null;
                    }
                    return this.getNamePool().getURIFromURICode((short)uriCode);
                }
                ++ns;
            }
        }
        if ((parent = this.getParent()) instanceof NamespaceResolver) {
            return ((NamespaceResolver)((Object)parent)).getURIForPrefix(prefix, useDefault);
        }
        return null;
    }

    @Override
    public boolean isId() {
        return this.tree.isIdElement(this.nodeNr);
    }

    @Override
    public boolean isIdref() {
        return this.tree.isIdrefElement(this.nodeNr);
    }
}

