/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.tinytree;

import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.SingletonIterator;
import net2.sf.saxon.tinytree.TinyNodeImpl;
import net2.sf.saxon.tinytree.TinyTree;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.Value;

final class TinyCommentImpl
extends TinyNodeImpl {
    public TinyCommentImpl(TinyTree tree, int nodeNr) {
        this.tree = tree;
        this.nodeNr = nodeNr;
    }

    @Override
    public final String getStringValue() {
        int start = this.tree.alpha[this.nodeNr];
        int len = this.tree.beta[this.nodeNr];
        if (len == 0) {
            return "";
        }
        char[] dest = new char[len];
        this.tree.commentBuffer.getChars(start, start + len, dest, 0);
        return new String(dest, 0, len);
    }

    @Override
    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator(new StringValue(this.getStringValue()));
    }

    @Override
    public Value atomize() {
        return new StringValue(this.getStringValue());
    }

    @Override
    public final int getNodeKind() {
        return 8;
    }

    @Override
    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        out.comment(this.getStringValue(), 0, 0);
    }
}

