/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.tinytree;

import net2.sf.saxon.sort.IntHashMap;
import net2.sf.saxon.tinytree.TinyBuilder;
import net2.sf.saxon.tinytree.TinyTextImpl;
import net2.sf.saxon.tinytree.TinyTree;
import net2.sf.saxon.trans.XPathException;

public class TinyBuilderCondensed
extends TinyBuilder {
    public IntHashMap<int[]> textValues = new IntHashMap(100);

    @Override
    protected int makeTextNode(CharSequence chars, int len) {
        TinyTree tree = this.getTree();
        int hash = chars.hashCode();
        int[] nodes = this.textValues.get(hash);
        if (nodes != null) {
            int used = nodes[0];
            int i = 1;
            while (i < used) {
                int nodeNr = nodes[i];
                if (nodeNr != 0) {
                    if (chars.equals(TinyTextImpl.getStringValue(tree, nodeNr))) {
                        return tree.addTextNodeCopy(this.getCurrentDepth(), nodeNr);
                    }
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            nodes = new int[4];
            nodes[0] = 1;
            this.textValues.put(hash, nodes);
        }
        if (nodes[0] + 1 > nodes.length) {
            int[] n2 = new int[nodes.length * 2];
            System.arraycopy(nodes, 0, n2, 0, nodes[0]);
            this.textValues.put(hash, n2);
            nodes = n2;
        }
        int newNode = super.makeTextNode(chars, len);
        int n = nodes[0];
        nodes[0] = n + 1;
        nodes[n] = newNode;
        return newNode;
    }

    @Override
    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        super.attribute(nameCode, typeCode, value.toString().intern(), locationId, properties);
    }
}

