/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.tinytree;

import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.tinytree.TinyNodeImpl;
import net2.sf.saxon.tinytree.TinyTree;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.Value;

final class TinyAttributeImpl
extends TinyNodeImpl {
    public TinyAttributeImpl(TinyTree tree, int nodeNr) {
        this.tree = tree;
        this.nodeNr = nodeNr;
    }

    @Override
    public void setSystemId(String uri) {
    }

    @Override
    public NodeInfo getParent() {
        return this.tree.getNode(this.tree.attParent[this.nodeNr]);
    }

    @Override
    public NodeInfo getRoot() {
        NodeInfo parent = this.getParent();
        if (parent == null) {
            return this;
        }
        return parent.getRoot();
    }

    @Override
    protected long getSequenceNumber() {
        return ((TinyNodeImpl)this.getParent()).getSequenceNumber() + 32768L + (long)(this.nodeNr - this.tree.alpha[this.tree.attParent[this.nodeNr]]);
    }

    @Override
    public final int getNodeKind() {
        return 2;
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.tree.attValue[this.nodeNr];
    }

    @Override
    public String getStringValue() {
        return this.tree.attValue[this.nodeNr].toString();
    }

    @Override
    public int getFingerprint() {
        return this.tree.attCode[this.nodeNr] & 0xFFFFF;
    }

    @Override
    public int getNameCode() {
        return this.tree.attCode[this.nodeNr];
    }

    @Override
    public String getPrefix() {
        int code = this.tree.attCode[this.nodeNr];
        if (!NamePool.isPrefixed(code)) {
            return "";
        }
        return this.tree.getNamePool().getPrefix(code);
    }

    @Override
    public String getDisplayName() {
        return this.tree.getNamePool().getDisplayName(this.tree.attCode[this.nodeNr]);
    }

    @Override
    public String getLocalPart() {
        return this.tree.getNamePool().getLocalName(this.tree.attCode[this.nodeNr]);
    }

    @Override
    public final String getURI() {
        return this.tree.getNamePool().getURI(this.tree.attCode[this.nodeNr]);
    }

    @Override
    public int getTypeAnnotation() {
        return this.tree.getAttributeAnnotation(this.nodeNr);
    }

    @Override
    public Value atomize() throws XPathException {
        return this.tree.getTypedValueOfAttribute(this);
    }

    @Override
    public SequenceIterator getTypedValue() throws XPathException {
        return this.tree.getTypedValueOfAttribute(this).iterate();
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        this.getParent().generateId(buffer);
        buffer.append("a");
        buffer.append(Integer.toString(this.tree.attCode[this.nodeNr]));
    }

    @Override
    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        int nameCode = this.tree.attCode[this.nodeNr];
        int typeCode = copyAnnotations ? this.getTypeAnnotation() : -1;
        out.attribute(nameCode, typeCode, this.getStringValue(), locationId, 0);
    }

    @Override
    public int getLineNumber() {
        return this.getParent().getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.getParent().getColumnNumber();
    }

    @Override
    public boolean isNilled() {
        return false;
    }

    @Override
    public boolean isId() {
        return this.tree.isIdAttribute(this.nodeNr);
    }

    @Override
    public boolean isIdref() {
        return this.tree.isIdrefAttribute(this.nodeNr);
    }
}

