/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.tinytree;

import net2.sf.saxon.om.AxisIteratorImpl;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.tinytree.TinyNodeImpl;
import net2.sf.saxon.tinytree.TinyTree;

final class FollowingEnumeration
extends AxisIteratorImpl {
    private TinyTree tree;
    private TinyNodeImpl startNode;
    private NodeTest test;
    private boolean includeDescendants;

    public FollowingEnumeration(TinyTree doc, TinyNodeImpl node, NodeTest nodeTest, boolean includeDescendants) {
        this.tree = doc;
        this.test = nodeTest;
        this.startNode = node;
        this.includeDescendants = includeDescendants;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Item next() {
        int nodeNr;
        block9: {
            block8: {
                block7: {
                    if (this.position > 0) break block7;
                    if (this.position < 0) {
                        return null;
                    }
                    nodeNr = this.startNode.nodeNr;
                    if (!this.includeDescendants) break block8;
                    ++nodeNr;
                    break block9;
                }
                nodeNr = ((TinyNodeImpl)this.current).nodeNr + 1;
                break block9;
            }
            while (true) {
                int nextSib;
                if ((nextSib = this.tree.next[nodeNr]) > nodeNr) {
                    nodeNr = nextSib;
                    break;
                }
                if (this.tree.depth[nextSib] == 0) {
                    this.current = null;
                    this.position = -1;
                    return null;
                }
                nodeNr = nextSib;
            }
        }
        while (true) {
            if (this.tree.depth[nodeNr] == 0) {
                this.current = null;
                this.position = -1;
                return null;
            }
            if (this.test.matches(this.tree, nodeNr)) {
                ++this.position;
                this.current = this.tree.getNode(nodeNr);
                return this.current;
            }
            ++nodeNr;
        }
    }

    @Override
    public SequenceIterator getAnother() {
        return new FollowingEnumeration(this.tree, this.startNode, this.test, this.includeDescendants);
    }
}

