/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.tinytree;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import net2.sf.saxon.om.FastStringBuffer;

public class CompressedWhitespace
implements CharSequence {
    private static char[] WHITE_CHARS = new char[]{'\t', '\n', '\r', ' '};
    private static int[] CODES;
    private long value;
    private static byte[] ESCAPE_N;
    private static byte[] ESCAPE_R;
    private static byte[] ESCAPE_T;

    static {
        int[] nArray = new int[33];
        nArray[0] = -1;
        nArray[1] = -1;
        nArray[2] = -1;
        nArray[3] = -1;
        nArray[4] = -1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = -1;
        nArray[8] = -1;
        nArray[10] = 1;
        nArray[11] = -1;
        nArray[12] = -1;
        nArray[13] = 2;
        nArray[14] = -1;
        nArray[15] = -1;
        nArray[16] = -1;
        nArray[17] = -1;
        nArray[18] = -1;
        nArray[19] = -1;
        nArray[20] = -1;
        nArray[21] = -1;
        nArray[22] = -1;
        nArray[23] = -1;
        nArray[24] = -1;
        nArray[25] = -1;
        nArray[26] = -1;
        nArray[27] = -1;
        nArray[28] = -1;
        nArray[29] = -1;
        nArray[30] = -1;
        nArray[31] = -1;
        nArray[32] = 3;
        CODES = nArray;
        ESCAPE_N = new byte[]{38, 35, 120, 65, 59};
        ESCAPE_R = new byte[]{38, 35, 120, 68, 59};
        ESCAPE_T = new byte[]{38, 35, 120, 57, 59};
    }

    public CompressedWhitespace(long compressedValue) {
        this.value = compressedValue;
    }

    public static CharSequence compress(CharSequence in) {
        int inlen = in.length();
        if (inlen == 0) {
            return in;
        }
        int runlength = 1;
        int outlength = 0;
        int i = 0;
        while (i < inlen) {
            char c = in.charAt(i);
            if (c <= ' ' && CODES[c] > 0) {
                if (i == inlen - 1 || c != in.charAt(i + 1) || runlength == 63) {
                    runlength = 1;
                    if (++outlength > 8) {
                        return in;
                    }
                } else {
                    ++runlength;
                }
            } else {
                return in;
            }
            ++i;
        }
        int ix = 0;
        runlength = 1;
        int[] out = new int[outlength];
        int i2 = 0;
        while (i2 < inlen) {
            char c = in.charAt(i2);
            if (i2 == inlen - 1 || c != in.charAt(i2 + 1) || runlength == 63) {
                out[ix++] = CODES[c] << 6 | runlength;
                runlength = 1;
            } else {
                ++runlength;
            }
            ++i2;
        }
        long value = 0L;
        int i3 = 0;
        while (i3 < outlength) {
            value = value << 8 | (long)out[i3];
            ++i3;
        }
        return new CompressedWhitespace(value <<= 8 * (8 - outlength));
    }

    public FastStringBuffer uncompress(FastStringBuffer buffer) {
        if (buffer == null) {
            buffer = new FastStringBuffer(this.length());
        }
        CompressedWhitespace.uncompress(this.value, buffer);
        return buffer;
    }

    public static void uncompress(long value, FastStringBuffer buffer) {
        int s = 56;
        while (s >= 0) {
            byte b = (byte)(value >>> s & 0xFFL);
            if (b == 0) break;
            char c = WHITE_CHARS[b >>> 6 & 3];
            int len = b & 0x3F;
            buffer.ensureCapacity(len);
            int j = 0;
            while (j < len) {
                buffer.append(c);
                ++j;
            }
            s -= 8;
        }
    }

    public long getCompressedValue() {
        return this.value;
    }

    @Override
    public int length() {
        int count = 0;
        long val = this.value;
        int s = 56;
        while (s >= 0) {
            int c = (int)(val >>> s & 0x3FL);
            if (c == 0) break;
            count += c;
            s -= 8;
        }
        return count;
    }

    @Override
    public char charAt(int index) {
        int count = 0;
        long val = this.value;
        int s = 56;
        while (s >= 0) {
            byte b = (byte)(val >>> s & 0xFFL);
            if (b == 0) break;
            if ((count += b & 0x3F) > index) {
                return WHITE_CHARS[b >>> 6 & 3];
            }
            s -= 8;
        }
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.uncompress(null).subSequence(start, end);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CompressedWhitespace) {
            return this.value == ((CompressedWhitespace)obj).value;
        }
        return this.uncompress(null).equals(obj);
    }

    public int hashCode() {
        return this.uncompress(null).hashCode();
    }

    @Override
    public String toString() {
        return this.uncompress(null).toString();
    }

    public void write(Writer writer) throws IOException {
        long val = this.value;
        int s = 56;
        while (s >= 0) {
            byte b = (byte)(val >>> s & 0xFFL);
            if (b == 0) break;
            char c = WHITE_CHARS[b >>> 6 & 3];
            int len = b & 0x3F;
            int j = 0;
            while (j < len) {
                writer.write(c);
                ++j;
            }
            s -= 8;
        }
    }

    public void writeEscape(boolean[] specialChars, Writer writer) throws IOException {
        long val = this.value;
        int s = 56;
        while (s >= 0) {
            byte b = (byte)(val >>> s & 0xFFL);
            if (b == 0) break;
            char c = WHITE_CHARS[b >>> 6 & 3];
            int len = b & 0x3F;
            if (specialChars[c]) {
                String e = "";
                if (c == '\n') {
                    e = "&#xA;";
                } else if (c == '\r') {
                    e = "&#xD;";
                } else if (c == '\t') {
                    e = "&#x9;";
                }
                int j = 0;
                while (j < len) {
                    writer.write(e);
                    ++j;
                }
            } else {
                int j = 0;
                while (j < len) {
                    writer.write(c);
                    ++j;
                }
            }
            s -= 8;
        }
    }

    public void writeEscape(boolean[] specialChars, OutputStream stream) throws IOException {
        long val = this.value;
        int s = 56;
        while (s >= 0) {
            byte b = (byte)(val >>> s & 0xFFL);
            if (b == 0) break;
            char c = WHITE_CHARS[b >>> 6 & 3];
            int len = b & 0x3F;
            if (specialChars[c]) {
                byte[] e = c == '\n' ? ESCAPE_N : (c == '\r' ? ESCAPE_R : ESCAPE_T);
                int j = 0;
                while (j < len) {
                    stream.write(e);
                    ++j;
                }
            } else {
                int j = 0;
                while (j < len) {
                    stream.write(c);
                    ++j;
                }
            }
            s -= 8;
        }
    }
}

