/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.sxpath;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.Source;
import net2.sf.saxon.Controller;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.PJConverter;
import net2.sf.saxon.expr.XPathContextMajor;
import net2.sf.saxon.instruct.SlotManager;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.sxpath.XPathDynamicContext;
import net2.sf.saxon.sxpath.XPathEvaluator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.SequenceExtent;
import net2.sf.saxon.value.Value;

public class XPathExpression
implements Serializable {
    private XPathEvaluator evaluator;
    private Expression expression;
    private SlotManager stackFrameMap;
    private int numberOfExternalVariables;

    protected XPathExpression(XPathEvaluator evaluator, Expression exp) {
        this.expression = exp;
        this.evaluator = evaluator;
    }

    protected void setStackFrameMap(SlotManager map, int numberOfExternalVariables) {
        this.stackFrameMap = map;
        this.numberOfExternalVariables = numberOfExternalVariables;
    }

    public XPathDynamicContext createDynamicContext(Item contextItem) {
        XPathContextMajor context = new XPathContextMajor(contextItem, this.evaluator.getExecutable());
        context.openStackFrame(this.stackFrameMap);
        return new XPathDynamicContext(context, this.stackFrameMap);
    }

    public XPathDynamicContext createDynamicContext(Controller controller, Item contextItem) throws XPathException {
        if (controller == null) {
            return this.createDynamicContext(contextItem);
        }
        XPathContextMajor context = controller.newXPathContext();
        context.openStackFrame(this.stackFrameMap);
        XPathDynamicContext dc = new XPathDynamicContext(context, this.stackFrameMap);
        dc.setContextItem(contextItem);
        return dc;
    }

    public SequenceIterator iterate(XPathDynamicContext context) throws XPathException {
        context.checkExternalVariables(this.stackFrameMap, this.numberOfExternalVariables);
        return this.expression.iterate(context.getXPathContextObject());
    }

    public List evaluate(XPathDynamicContext context) throws XPathException {
        Item item;
        SequenceIterator iter = this.expression.iterate(context.getXPathContextObject());
        ArrayList<Item> list = new ArrayList<Item>(20);
        while ((item = iter.next()) != null) {
            list.add(item);
        }
        return list;
    }

    public Item evaluateSingle(XPathDynamicContext context) throws XPathException {
        return this.expression.iterate(context.getXPathContextObject()).next();
    }

    public boolean effectiveBooleanValue(XPathDynamicContext context) throws XPathException {
        return this.expression.effectiveBooleanValue(context.getXPathContextObject());
    }

    public List evaluate(Source source) throws XPathException {
        NodeInfo origin = source instanceof NodeInfo ? (NodeInfo)source : this.evaluator.getConfiguration().buildDocument(source);
        XPathDynamicContext dynamicContext = this.createDynamicContext(origin);
        SequenceIterator iter = this.iterate(dynamicContext);
        SequenceExtent extent = new SequenceExtent(iter);
        List result = (List)PJConverter.ToCollection.INSTANCE.convert(extent, List.class, dynamicContext.getXPathContextObject());
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    public Object evaluateSingle(Source source) throws XPathException {
        NodeInfo origin = source instanceof NodeInfo ? (NodeInfo)source : this.evaluator.getConfiguration().buildDocument(source);
        XPathDynamicContext context = this.createDynamicContext(origin);
        SequenceIterator iterator = this.iterate(context);
        Item item = iterator.next();
        if (item == null) {
            return null;
        }
        return Value.convertToJava(item);
    }

    public SequenceIterator rawIterator(Source source) throws XPathException {
        NodeInfo origin = source instanceof NodeInfo ? (NodeInfo)source : this.evaluator.getConfiguration().buildDocument(source);
        XPathDynamicContext context = this.createDynamicContext(origin);
        return this.iterate(context);
    }

    public Expression getInternalExpression() {
        return this.expression;
    }
}

