/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net2.sf.saxon.expr.Binding;
import net2.sf.saxon.expr.BindingReference;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.Optimizer;
import net2.sf.saxon.expr.VariableDeclaration;
import net2.sf.saxon.instruct.GeneralVariable;
import net2.sf.saxon.instruct.GlobalVariable;
import net2.sf.saxon.instruct.SlotManager;
import net2.sf.saxon.pattern.AnyNodeTest;
import net2.sf.saxon.style.StylesheetProcedure;
import net2.sf.saxon.style.XSLGeneralVariable;
import net2.sf.saxon.style.XSLStylesheet;
import net2.sf.saxon.style.XSLVariable;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.SequenceType;
import net2.sf.saxon.value.Value;

public abstract class XSLVariableDeclaration
extends XSLGeneralVariable
implements VariableDeclaration,
StylesheetProcedure {
    private int slotNumber = -9876;
    protected List references = new ArrayList(10);

    @Override
    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(int slot) {
        this.slotNumber = slot;
    }

    public abstract SequenceType getRequiredType();

    @Override
    public void registerReference(BindingReference ref) {
        this.references.add(ref);
    }

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public void fixupReferences() throws XPathException {
        SequenceType type = this.getRequiredType();
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        Iterator iter = this.references.iterator();
        while (iter.hasNext()) {
            Value constantValue = null;
            int properties = 0;
            if (this instanceof XSLVariable && !this.isAssignable()) {
                int relation;
                if (this.select instanceof Literal && ((relation = th.relationship(this.select.getItemType(th), type.getPrimaryType())) == 0 || relation == 2)) {
                    constantValue = ((Literal)this.select).getValue();
                }
                if (this.select != null) {
                    properties = this.select.getSpecialProperties();
                }
            }
            ((BindingReference)iter.next()).setStaticType(type, constantValue, properties);
        }
        super.fixupReferences();
    }

    @Override
    public void validate() throws XPathException {
        super.validate();
        if (this.global && !this.redundant) {
            this.slotNumber = this.getPrincipalStylesheet().allocateGlobalSlot(this.getVariableQName());
        }
    }

    protected void fixupBinding(Binding binding) {
        Iterator iter = this.references.iterator();
        while (iter.hasNext()) {
            ((BindingReference)iter.next()).fixup(binding);
        }
    }

    @Override
    protected void setReferenceCount(GeneralVariable var) {
        var.setReferenceCount(10);
    }

    @Override
    protected void index(XSLStylesheet top) throws XPathException {
        top.indexVariableDeclaration(this);
    }

    @Override
    public void optimize() throws XPathException {
        if (this.global && !this.redundant && this.select != null) {
            Expression exp2 = this.select;
            ExpressionVisitor visitor = this.makeExpressionVisitor();
            Optimizer opt = this.getConfiguration().getOptimizer();
            try {
                if (opt.getOptimizationLevel() != 0) {
                    exp2 = exp2.optimize(visitor, AnyNodeTest.getInstance());
                }
            }
            catch (XPathException err) {
                err.maybeSetLocation(this);
                this.compileError(err);
            }
            this.allocateSlots(exp2);
            if (this.slotManager != null && this.slotManager.getNumberOfVariables() > 0) {
                ((GlobalVariable)this.compiledVariable).setContainsLocals(this.slotManager);
            }
            if (exp2 != this.select) {
                this.select = exp2;
                this.compiledVariable.setSelectExpression(this.select);
            }
        }
    }

    public GeneralVariable getCompiledVariable() {
        return this.compiledVariable;
    }
}

