/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.instruct.ValueOf;
import net2.sf.saxon.om.AttributeCollection;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.pattern.NodeKindTest;
import net2.sf.saxon.style.StyleElement;
import net2.sf.saxon.style.XSLStringConstructor;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.Whitespace;

public class XSLText
extends XSLStringConstructor {
    private boolean disable = false;
    private StringValue value;

    @Override
    protected ItemType getReturnedItemType() {
        return NodeKindTest.TEXT;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        String disableAtt = null;
        AttributeCollection atts = this.getAttributeList();
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("disable-output-escaping")) {
                disableAtt = Whitespace.trim(atts.getValue(a));
            } else {
                this.checkUnknownAttribute(nc);
            }
            ++a;
        }
        if (disableAtt != null) {
            if (disableAtt.equals("yes")) {
                this.disable = true;
            } else if (disableAtt.equals("no")) {
                this.disable = false;
            } else {
                this.compileError("disable-output-escaping attribute must be either 'yes' or 'no'", "XTSE0020");
            }
        }
    }

    @Override
    public void validate() throws XPathException {
        Item child;
        AxisIterator kids = this.iterateAxis((byte)3);
        this.value = StringValue.EMPTY_STRING;
        while ((child = kids.next()) != null) {
            if (child instanceof StyleElement) {
                ((StyleElement)child).compileError("xsl:text must not contain child elements", "XTSE0010");
                return;
            }
            this.value = StringValue.makeStringValue(child.getStringValueCS());
        }
        super.validate();
    }

    @Override
    protected String getErrorCodeForSelectPlusContent() {
        return null;
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        return new ValueOf(Literal.makeLiteral(this.value), this.disable, false);
    }
}

