/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import java.io.Serializable;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerException;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.Optimizer;
import net2.sf.saxon.expr.RoleLocator;
import net2.sf.saxon.expr.TypeChecker;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.instruct.SlotManager;
import net2.sf.saxon.instruct.Template;
import net2.sf.saxon.instruct.TraceInstruction;
import net2.sf.saxon.om.AttributeCollection;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.NamespaceException;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.pattern.EmptySequenceTest;
import net2.sf.saxon.pattern.Pattern;
import net2.sf.saxon.style.StyleElement;
import net2.sf.saxon.style.StylesheetProcedure;
import net2.sf.saxon.style.XSLParam;
import net2.sf.saxon.style.XSLStylesheet;
import net2.sf.saxon.trans.Mode;
import net2.sf.saxon.trans.RuleManager;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.Type;
import net2.sf.saxon.value.DecimalValue;
import net2.sf.saxon.value.SequenceType;
import net2.sf.saxon.value.Whitespace;

public final class XSLTemplate
extends StyleElement
implements StylesheetProcedure {
    private String matchAtt = null;
    private String modeAtt = null;
    private String nameAtt = null;
    private String priorityAtt = null;
    private String asAtt = null;
    private StructuredQName[] modeNames;
    private String diagnosticId;
    private Pattern match;
    private boolean prioritySpecified;
    private double priority;
    private SlotManager stackFrameMap;
    private Template compiledTemplate = new Template();
    private SequenceType requiredType = null;
    private boolean hasRequiredParams = false;

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    protected boolean mayContainParam(String attName) {
        return true;
    }

    @Override
    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLParam;
    }

    public StructuredQName getTemplateName() {
        try {
            String nameAtt;
            if (this.getObjectName() == null && (nameAtt = this.getAttributeValue("", "name")) != null) {
                this.setObjectName(this.makeQName(nameAtt));
            }
            return this.getObjectName();
        }
        catch (NamespaceException err) {
            return null;
        }
        catch (XPathException err) {
            return null;
        }
    }

    @Override
    protected ItemType getReturnedItemType() {
        if (this.requiredType == null) {
            return this.getCommonChildItemType();
        }
        return this.requiredType.getPrimaryType();
    }

    private int getMinImportPrecedence() {
        return this.getContainingStylesheet().getMinImportPrecedence();
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("mode")) {
                this.modeAtt = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("name")) {
                this.nameAtt = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("match")) {
                this.matchAtt = atts.getValue(a);
            } else if (f.equals("priority")) {
                this.priorityAtt = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("as")) {
                this.asAtt = atts.getValue(a);
            } else {
                this.checkUnknownAttribute(nc);
            }
            ++a;
        }
        try {
            if (this.modeAtt == null) {
                this.modeNames = new StructuredQName[1];
                this.modeNames[0] = Mode.DEFAULT_MODE_NAME;
            } else {
                if (this.matchAtt == null) {
                    this.compileError("The mode attribute must be absent if the match attribute is absent", "XTSE0500");
                }
                int count = 0;
                boolean allModes = false;
                StringTokenizer st = new StringTokenizer(this.modeAtt, " \t\n\r", false);
                while (st.hasMoreTokens()) {
                    st.nextToken();
                    ++count;
                }
                if (count == 0) {
                    this.compileError("The mode attribute must not be empty", "XTSE0550");
                }
                this.modeNames = new StructuredQName[count];
                count = 0;
                st = new StringTokenizer(this.modeAtt, " \t\n\r", false);
                while (st.hasMoreTokens()) {
                    StructuredQName mname;
                    String s = st.nextToken();
                    if ("#default".equals(s)) {
                        mname = Mode.DEFAULT_MODE_NAME;
                    } else if ("#all".equals(s)) {
                        allModes = true;
                        mname = Mode.ALL_MODES;
                    } else {
                        mname = this.makeQName(s);
                    }
                    int e = 0;
                    while (e < count) {
                        if (this.modeNames[e].equals(mname)) {
                            this.compileError("In the list of modes, the value " + s + " is duplicated", "XTSE0550");
                        }
                        ++e;
                    }
                    this.modeNames[count++] = mname;
                }
                if (allModes && count > 1) {
                    this.compileError("mode='#all' cannot be combined with other modes", "XTSE0550");
                }
            }
        }
        catch (NamespaceException err) {
            this.compileError(err.getMessage(), "XTSE0280");
        }
        catch (XPathException err) {
            err.maybeSetErrorCode("XTSE0280");
            if (err.getErrorCodeLocalPart().equals("XTSE0020")) {
                err.setErrorCode("XTSE0550");
            }
            err.setIsStaticError(true);
            this.compileError(err);
        }
        try {
            if (this.nameAtt != null) {
                StructuredQName qName = this.makeQName(this.nameAtt);
                this.setObjectName(qName);
                this.diagnosticId = this.nameAtt;
            }
        }
        catch (NamespaceException err) {
            this.compileError(err.getMessage(), "XTSE0280");
        }
        catch (XPathException err) {
            err.maybeSetErrorCode("XTSE0280");
            err.setIsStaticError(true);
            this.compileError(err);
        }
        boolean bl = this.prioritySpecified = this.priorityAtt != null;
        if (this.prioritySpecified) {
            if (this.matchAtt == null) {
                this.compileError("The priority attribute must be absent if the match attribute is absent", "XTSE0500");
            }
            try {
                if (!DecimalValue.castableAsDecimal(this.priorityAtt)) {
                    this.compileError("Invalid numeric value for priority (" + this.priority + ')', "XTSE0530");
                }
                this.priority = Double.parseDouble(this.priorityAtt);
            }
            catch (NumberFormatException err) {
                this.compileError("Invalid numeric value for priority (" + this.priority + ')', "XTSE0530");
            }
        }
        if (this.matchAtt != null) {
            this.match = this.makePattern(this.matchAtt);
            if (this.diagnosticId == null) {
                this.diagnosticId = "match=\"" + this.matchAtt + '\"';
                if (this.modeAtt != null) {
                    this.diagnosticId = String.valueOf(this.diagnosticId) + " mode=\"" + this.modeAtt + '\"';
                }
            }
        }
        if (this.match == null && this.nameAtt == null) {
            this.compileError("xsl:template must have a name or match attribute (or both)", "XTSE0500");
        }
        if (this.asAtt != null) {
            this.requiredType = this.makeSequenceType(this.asAtt);
        }
    }

    @Override
    public void validate() throws XPathException {
        NodeInfo param;
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        this.checkTopLevel(null);
        if (this.match != null) {
            this.match = this.typeCheck("match", this.match);
            if (this.match.getNodeTest() instanceof EmptySequenceTest) {
                try {
                    this.getConfiguration().getErrorListener().warning(new TransformerException("Match pattern cannot match any nodes", this));
                }
                catch (TransformerException e) {
                    this.compileError(XPathException.makeXPathException(e));
                }
            }
        }
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((param = (NodeInfo)kids.next()) != null) {
            if (!(param instanceof XSLParam) || !((XSLParam)param).isRequiredParam()) continue;
            this.hasRequiredParams = true;
            break;
        }
    }

    @Override
    public void postValidate() throws XPathException {
        this.markTailCalls();
    }

    @Override
    protected void index(XSLStylesheet top) throws XPathException {
        top.indexNamedTemplate(this);
    }

    @Override
    public boolean markTailCalls() {
        StyleElement last = this.getLastChildInstruction();
        return last != null && last.markTailCalls();
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        Expression block = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
        if (block == null) {
            block = Literal.makeEmptySequence();
        }
        this.compiledTemplate.setMatchPattern(this.match);
        this.compiledTemplate.setBody(block);
        this.compiledTemplate.setStackFrameMap(this.stackFrameMap);
        this.compiledTemplate.setExecutable(this.getExecutable());
        this.compiledTemplate.setSystemId(this.getSystemId());
        this.compiledTemplate.setLineNumber(this.getLineNumber());
        this.compiledTemplate.setHasRequiredParams(this.hasRequiredParams);
        this.compiledTemplate.setRequiredType(this.requiredType);
        Expression exp = null;
        try {
            exp = this.makeExpressionVisitor().simplify(block);
        }
        catch (XPathException e) {
            this.compileError(e);
        }
        try {
            if (this.requiredType != null) {
                RoleLocator role = new RoleLocator(7, (Serializable)((Object)this.diagnosticId), 0);
                role.setErrorCode("XTTE0505");
                exp = TypeChecker.staticTypeCheck(exp, this.requiredType, false, role, this.makeExpressionVisitor());
            }
        }
        catch (XPathException err) {
            this.compileError(err);
        }
        this.compiledTemplate.setBody(exp);
        this.compiledTemplate.init(this.getObjectName(), this.getPrecedence(), this.getMinImportPrecedence());
        if (this.getConfiguration().isCompileWithTracing()) {
            TraceInstruction trace = new TraceInstruction(exp, this);
            trace.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            trace.setContainer(this.compiledTemplate);
            exp = trace;
            this.compiledTemplate.setBody(exp);
        }
        return null;
    }

    @Override
    public void optimize() throws XPathException {
        Expression exp2;
        ItemType contextItemType = Type.ITEM_TYPE;
        if (this.getObjectName() == null) {
            contextItemType = this.match.getNodeTest();
        }
        if (this.match != null) {
            int slots = this.match.allocateSlots(this.getStaticContext(), this.getSlotManager(), 0);
            RuleManager mgr = this.getPrincipalStylesheet().getRuleManager();
            int i = 0;
            while (i < this.modeNames.length) {
                StructuredQName nc = this.modeNames[i];
                Mode mode = mgr.getMode(nc, true);
                if (this.prioritySpecified) {
                    mgr.setHandler(this.match, this.compiledTemplate, mode, this.getPrecedence(), this.priority);
                } else {
                    mgr.setHandler(this.match, this.compiledTemplate, mode, this.getPrecedence());
                }
                mode.allocatePatternSlots(slots);
                if (mode.isStreamable()) {
                    this.compiledTemplate.setStreamable(true);
                }
                ++i;
            }
            this.allocatePatternSlots(slots);
        }
        Expression exp = this.compiledTemplate.getBody();
        ExpressionVisitor visitor = this.makeExpressionVisitor();
        Optimizer opt = this.getConfiguration().getOptimizer();
        try {
            exp2 = visitor.typeCheck(exp, contextItemType);
            if (opt.getOptimizationLevel() != 0) {
                exp2 = visitor.optimize(exp2, contextItemType);
            }
            if (exp != exp2) {
                this.compiledTemplate.setBody(exp2);
                exp = exp2;
            }
        }
        catch (XPathException e) {
            this.compileError(e);
        }
        if (opt.getOptimizationLevel() != 0 && !this.getConfiguration().isCompileWithTracing() && exp != (exp2 = opt.promoteExpressionsToGlobal(exp, visitor, false))) {
            this.compiledTemplate.setBody(exp2);
            exp = exp2;
        }
        this.allocateSlots(exp);
        if (this.isExplaining()) {
            System.err.println("Optimized expression tree for template at line " + this.getLineNumber() + " in " + this.getSystemId() + ':');
            exp.explain(System.err);
        }
    }

    @Override
    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public Template getCompiledTemplate() {
        return this.compiledTemplate;
    }

    @Override
    public int getConstructType() {
        return 181;
    }
}

