/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.PreparedStylesheet;
import net2.sf.saxon.expr.CollationMap;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.functions.ConstructorFunctionLibrary;
import net2.sf.saxon.functions.ExecutableFunctionLibrary;
import net2.sf.saxon.functions.FunctionLibrary;
import net2.sf.saxon.functions.FunctionLibraryList;
import net2.sf.saxon.functions.SystemFunctionLibrary;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.instruct.LocationMap;
import net2.sf.saxon.om.AttributeCollection;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.om.Validation;
import net2.sf.saxon.query.XQueryFunction;
import net2.sf.saxon.query.XQueryFunctionLibrary;
import net2.sf.saxon.sort.CodepointCollator;
import net2.sf.saxon.sort.IntHashMap;
import net2.sf.saxon.sort.StringCollator;
import net2.sf.saxon.style.AbsentExtensionElement;
import net2.sf.saxon.style.CollationDeclaration;
import net2.sf.saxon.style.DataElement;
import net2.sf.saxon.style.StyleElement;
import net2.sf.saxon.style.StylesheetFunctionLibrary;
import net2.sf.saxon.style.StylesheetProcedure;
import net2.sf.saxon.style.XSLAttributeSet;
import net2.sf.saxon.style.XSLCharacterMap;
import net2.sf.saxon.style.XSLDecimalFormat;
import net2.sf.saxon.style.XSLFunction;
import net2.sf.saxon.style.XSLGeneralIncorporate;
import net2.sf.saxon.style.XSLImport;
import net2.sf.saxon.style.XSLImportSchema;
import net2.sf.saxon.style.XSLInclude;
import net2.sf.saxon.style.XSLKey;
import net2.sf.saxon.style.XSLNamespaceAlias;
import net2.sf.saxon.style.XSLOutput;
import net2.sf.saxon.style.XSLParam;
import net2.sf.saxon.style.XSLPreserveSpace;
import net2.sf.saxon.style.XSLTemplate;
import net2.sf.saxon.style.XSLVariable;
import net2.sf.saxon.style.XSLVariableDeclaration;
import net2.sf.saxon.trans.KeyManager;
import net2.sf.saxon.trans.Mode;
import net2.sf.saxon.trans.RuleManager;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.Whitespace;

public class XSLStylesheet
extends StyleElement {
    Executable exec;
    private LocationMap locationMap = new LocationMap();
    private HashMap<StructuredQName, XSLVariableDeclaration> globalVariableIndex = new HashMap(20);
    private boolean wasIncluded = false;
    private int precedence = 0;
    private int minImportPrecedence = 0;
    private XSLStylesheet importer = null;
    private PreparedStylesheet stylesheet;
    private List topLevel;
    private HashMap<StructuredQName, XSLTemplate> templateIndex = new HashMap(20);
    private int inputAnnotations = 0;
    public static final int ANNOTATION_STRIP = 1;
    public static final int ANNOTATION_PRESERVE = 2;
    private HashSet<String> schemaIndex = new HashSet(10);
    private XQueryFunctionLibrary queryFunctions;
    private int numberOfAliases = 0;
    private List<XSLNamespaceAlias> namespaceAliasList = new ArrayList<XSLNamespaceAlias>(5);
    private short[] aliasSCodes;
    private int[] aliasNCodes;
    private int largestPatternStackFrame = 0;
    private int defaultValidation = 4;
    private FunctionLibraryList functionLibrary;
    private boolean needsDynamicOutputProperties = false;
    private HashMap<StructuredQName, Integer> localParameterNumbers = null;

    public void setPreparedStylesheet(PreparedStylesheet sheet) {
        Configuration config = sheet.getConfiguration();
        this.stylesheet = sheet;
        this.exec = sheet.getExecutable();
        this.functionLibrary = new FunctionLibraryList();
        this.functionLibrary.addFunctionLibrary(SystemFunctionLibrary.getSystemFunctionLibrary(3));
        this.functionLibrary.addFunctionLibrary(new StylesheetFunctionLibrary(this, true));
        this.functionLibrary.addFunctionLibrary(config.getVendorFunctionLibrary());
        this.functionLibrary.addFunctionLibrary(new ConstructorFunctionLibrary(config));
        this.queryFunctions = new XQueryFunctionLibrary(config);
        this.functionLibrary.addFunctionLibrary(this.queryFunctions);
        this.functionLibrary.addFunctionLibrary(config.getIntegratedFunctionLibrary());
        config.addExtensionBinders(this.functionLibrary);
        this.functionLibrary.addFunctionLibrary(new StylesheetFunctionLibrary(this, false));
    }

    @Override
    public PreparedStylesheet getPreparedStylesheet() {
        if (this.importer != null) {
            return this.importer.getPreparedStylesheet();
        }
        return this.stylesheet;
    }

    @Override
    public Executable getExecutable() {
        return this.exec;
    }

    @Override
    protected boolean mayContainParam(String attName) {
        return true;
    }

    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    public LocationMap getLocationMap() {
        return this.locationMap;
    }

    public RuleManager getRuleManager() {
        return this.exec.getRuleManager();
    }

    protected Mode getStripperRules() {
        if (this.exec.getStripperRules() == null) {
            this.exec.setStripperRules(new Mode(-4, Mode.DEFAULT_MODE_NAME));
        }
        return this.exec.getStripperRules();
    }

    public boolean stripsWhitespace() {
        int i = 0;
        while (i < this.topLevel.size()) {
            NodeInfo s = (NodeInfo)this.topLevel.get(i);
            if (s.getFingerprint() == 179) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public KeyManager getKeyManager() {
        if (this.exec.getKeyManager() == null) {
            this.exec.setKeyManager(new KeyManager(this.getConfiguration()));
        }
        return this.exec.getKeyManager();
    }

    public CollationMap getCollationMap() {
        return this.exec.getCollationTable();
    }

    public void setCollation(String name, StringCollator collation) {
        if (this.exec.getCollationTable() == null) {
            this.exec.setCollationTable(new CollationMap(this.getConfiguration()));
        }
        this.exec.getCollationTable().setNamedCollation(name, collation);
    }

    protected StringCollator findCollation(String name) {
        if (name.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            return CodepointCollator.getInstance();
        }
        StringCollator c = null;
        if (this.exec.getCollationTable() != null) {
            c = this.exec.getCollationTable().getNamedCollation(name);
        }
        if (c != null) {
            return c;
        }
        XSLStylesheet stylesheet = this.getPrincipalStylesheet();
        List toplevel = stylesheet.getTopLevel();
        int i = toplevel.size() - 1;
        while (i >= 0) {
            CollationDeclaration t;
            if (toplevel.get(i) instanceof CollationDeclaration && (t = (CollationDeclaration)toplevel.get(i)).getCollationName().equals(name)) {
                return t.getCollator();
            }
            --i;
        }
        Configuration config = this.getConfiguration();
        return config.getCollationURIResolver().resolve(name, this.getBaseURI(), config);
    }

    public XSLCharacterMap getCharacterMap(StructuredQName name) {
        int i = this.topLevel.size() - 1;
        while (i >= 0) {
            XSLCharacterMap t;
            if (this.topLevel.get(i) instanceof XSLCharacterMap && (t = (XSLCharacterMap)this.topLevel.get(i)).getCharacterMapName().equals(name)) {
                return t;
            }
            --i;
        }
        return null;
    }

    public void setPrecedence(int prec) {
        this.precedence = prec;
    }

    @Override
    public int getPrecedence() {
        if (this.wasIncluded) {
            return this.importer.getPrecedence();
        }
        return this.precedence;
    }

    public int getMinImportPrecedence() {
        return this.minImportPrecedence;
    }

    public void setMinImportPrecedence(int precedence) {
        this.minImportPrecedence = precedence;
    }

    public void setImporter(XSLStylesheet importer) {
        this.importer = importer;
    }

    public XSLStylesheet getImporter() {
        return this.importer;
    }

    public void setWasIncluded() {
        this.wasIncluded = true;
    }

    public List getTopLevel() {
        return this.topLevel;
    }

    public int allocateGlobalSlot(StructuredQName qName) {
        return this.exec.getGlobalVariableMap().allocateSlotNumber(qName);
    }

    @Override
    public void allocatePatternSlots(int n) {
        if (n > this.largestPatternStackFrame) {
            this.largestPatternStackFrame = n;
        }
    }

    @Override
    public void prepareAttributes() throws XPathException {
        String inputTypeAnnotationsAtt = null;
        AttributeCollection atts = this.getAttributeList();
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (!(f.equals("version") || f.equals("id") || f.equals("extension-element-prefixes") || f.equals("exclude-result-prefixes"))) {
                if (f.equals("default-validation")) {
                    this.defaultValidation = Validation.getCode(atts.getValue(a));
                    if (this.defaultValidation == -1) {
                        this.compileError("Invalid value for default-validation attribute. Permitted values are (strict, lax, preserve, strip)", "XTSE0020");
                    } else if (!this.getExecutable().isSchemaAware() && this.defaultValidation != 4) {
                        this.defaultValidation = 4;
                        this.compileError("default-validation='" + atts.getValue(a) + "' requires a schema-aware processor", "XTSE1660");
                    }
                } else if (f.equals("input-type-annotations")) {
                    inputTypeAnnotationsAtt = atts.getValue(a);
                } else {
                    this.checkUnknownAttribute(nc);
                }
            }
            ++a;
        }
        if (this.version == null) {
            this.reportAbsence("version");
        }
        if (inputTypeAnnotationsAtt != null) {
            if (inputTypeAnnotationsAtt.equals("strip")) {
                this.setInputTypeAnnotations(1);
            } else if (inputTypeAnnotationsAtt.equals("preserve")) {
                this.setInputTypeAnnotations(2);
            } else if (!inputTypeAnnotationsAtt.equals("unspecified")) {
                this.compileError("Invalid value for input-type-annotations attribute. Permitted values are (strip, preserve, unspecified)", "XTSE0020");
            }
        }
    }

    public int getDefaultValidation() {
        return this.defaultValidation;
    }

    public int getInputTypeAnnotationsAttribute() throws XPathException {
        String inputTypeAnnotationsAtt = this.getAttributeValue("", "input-type-annotations");
        if (inputTypeAnnotationsAtt != null) {
            if (inputTypeAnnotationsAtt.equals("strip")) {
                this.setInputTypeAnnotations(1);
            } else if (inputTypeAnnotationsAtt.equals("preserve")) {
                this.setInputTypeAnnotations(2);
            } else if (!inputTypeAnnotationsAtt.equals("unspecified")) {
                this.compileError("Invalid value for input-type-annotations attribute. Permitted values are (strip, preserve, unspecified)", "XTSE0020");
            }
        }
        return this.inputAnnotations;
    }

    public int getInputTypeAnnotations() {
        return this.inputAnnotations;
    }

    public void setInputTypeAnnotations(int annotations) throws XPathException {
        this.inputAnnotations |= annotations;
        if (this.inputAnnotations == 3) {
            this.compileError("One stylesheet module specifies input-type-annotations='strip', another specifies input-type-annotations='preserve'", "XTSE0265");
        }
    }

    protected int getNamespaceAlias(short uriCode) {
        int i = 0;
        while (i < this.numberOfAliases) {
            if (uriCode == this.aliasSCodes[i]) {
                return this.aliasNCodes[i];
            }
            ++i;
        }
        return uriCode;
    }

    protected boolean isAliasResultNamespace(short uriCode) {
        int i = 0;
        while (i < this.numberOfAliases) {
            if (uriCode == (this.aliasNCodes[i] & 0xFFFF)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void validate() throws XPathException {
        NodeInfo curr;
        if (this.validationError != null) {
            this.compileError(this.validationError);
        }
        if (this.getParent().getNodeKind() != 9) {
            this.compileError(String.valueOf(this.getDisplayName()) + " must be the outermost element", "XTSE0010");
        }
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((curr = (NodeInfo)kids.next()) != null) {
            if (curr.getNodeKind() == 3 || curr instanceof XSLTemplate || curr instanceof XSLImport || curr instanceof XSLInclude || curr instanceof XSLAttributeSet || curr instanceof XSLCharacterMap || curr instanceof XSLDecimalFormat || curr instanceof XSLFunction || curr instanceof XSLImportSchema || curr instanceof XSLKey || curr instanceof XSLNamespaceAlias || curr instanceof XSLOutput || curr instanceof XSLParam || curr instanceof XSLPreserveSpace || curr instanceof XSLVariable || curr instanceof DataElement || !"http://www.w3.org/1999/XSL/Transform".equals(curr.getURI()) && !"".equals(curr.getURI()) || curr instanceof AbsentExtensionElement && ((StyleElement)curr).forwardsCompatibleModeIsEnabled()) continue;
            if ("http://www.w3.org/1999/XSL/Transform".equals(curr.getURI())) {
                ((StyleElement)curr).compileError("Element " + curr.getDisplayName() + " must not appear directly within " + this.getDisplayName(), "XTSE0010");
                continue;
            }
            ((StyleElement)curr).compileError("Element " + curr.getDisplayName() + " must not appear directly within " + this.getDisplayName() + " because it is not in a namespace", "XTSE0130");
        }
    }

    public void preprocess() throws XPathException {
        Object node;
        this.spliceIncludes();
        this.buildIndexes();
        this.checkForSchemaAwareness();
        this.processAllAttributes();
        this.collectNamespaceAliases();
        int i = 0;
        while (i < this.topLevel.size()) {
            node = this.topLevel.get(i);
            if (node instanceof StyleElement) {
                ((StyleElement)node).fixupReferences();
            }
            ++i;
        }
        this.validate();
        i = 0;
        while (i < this.topLevel.size()) {
            node = this.topLevel.get(i);
            if (node instanceof StyleElement) {
                ((StyleElement)node).validateSubtree();
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void spliceIncludes() throws XPathException {
        foundNonImport = false;
        this.topLevel = new ArrayList<E>(50);
        this.minImportPrecedence = this.precedence;
        previousElement /* !! */  = this;
        kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            block11: {
                if (child.getNodeKind() == 3) {
                    if (Whitespace.isWhite(child.getStringValueCS())) continue;
                    previousElement /* !! */ .compileError("No character data is allowed between top-level elements", "XTSE0120");
                    continue;
                }
                if (child instanceof DataElement) {
                    foundNonImport = true;
                    continue;
                }
                previousElement /* !! */  = (StyleElement)child;
                if (!(child instanceof XSLGeneralIncorporate)) break block11;
                xslinc = (XSLGeneralIncorporate)child;
                xslinc.processAttributes();
                if (xslinc.isImport()) {
                    if (foundNonImport) {
                        xslinc.compileError("xsl:import elements must come first", "XTSE0200");
                    }
                } else {
                    foundNonImport = true;
                }
                if ((inc = xslinc.getIncludedStylesheet(this, this.precedence)) == null) {
                    return;
                }
                if (xslinc.isImport()) {
                    this.precedence = inc.getPrecedence() + 1;
                } else {
                    this.precedence = inc.getPrecedence();
                    inc.setMinImportPrecedence(this.minImportPrecedence);
                    inc.setWasIncluded();
                }
                incchildren = inc.topLevel;
                j = 0;
                while (j < incchildren.size()) {
                    block12: {
                        elem = (StyleElement)incchildren.get(j);
                        last = this.topLevel.size() - 1;
                        if (last >= 0 && elem.getPrecedence() < ((StyleElement)this.topLevel.get(last)).getPrecedence()) ** GOTO lbl41
                        this.topLevel.add(elem);
                        break block12;
lbl-1000:
                        // 1 sources

                        {
                            --last;
lbl41:
                            // 2 sources

                            ** while (last >= 0 && elem.getPrecedence() < ((StyleElement)this.topLevel.get((int)last)).getPrecedence())
                        }
lbl42:
                        // 1 sources

                        this.topLevel.add(last + 1, elem);
                    }
                    ++j;
                }
                continue;
            }
            foundNonImport = true;
            this.topLevel.add(child);
        }
    }

    private void buildIndexes() throws XPathException {
        int i = this.topLevel.size() - 1;
        while (i >= 0) {
            Object node = this.topLevel.get(i);
            if (node instanceof StyleElement) {
                ((StyleElement)node).index(this);
            }
            --i;
        }
        Configuration config = this.getConfiguration();
        for (String ns : this.schemaIndex) {
            config.sealNamespace(ns);
        }
    }

    protected void addNamespaceAlias(XSLNamespaceAlias node) {
        this.namespaceAliasList.add(node);
        ++this.numberOfAliases;
    }

    private void checkForSchemaAwareness() {
        Executable exec = this.getExecutable();
        if (!exec.isSchemaAware() && exec.getConfiguration().isLicensedFeature(2)) {
            int i = 0;
            while (i < this.topLevel.size()) {
                Object node = this.topLevel.get(i);
                if (node instanceof XSLImportSchema) {
                    exec.setSchemaAware(true);
                    return;
                }
                ++i;
            }
        }
    }

    protected void indexVariableDeclaration(XSLVariableDeclaration var) throws XPathException {
        StructuredQName qName = var.getVariableQName();
        if (qName != null) {
            XSLVariableDeclaration other = this.globalVariableIndex.get(qName);
            if (other == null) {
                this.globalVariableIndex.put(qName, var);
            } else {
                int otherPrecedence;
                int thisPrecedence = var.getPrecedence();
                if (thisPrecedence == (otherPrecedence = other.getPrecedence())) {
                    var.compileError("Duplicate global variable declaration (see line " + other.getLineNumber() + " of " + other.getSystemId() + ')', "XTSE0630");
                } else if (thisPrecedence < otherPrecedence) {
                    var.setRedundant();
                } else {
                    other.setRedundant();
                    this.globalVariableIndex.put(qName, var);
                }
            }
        }
    }

    protected void indexNamedTemplate(XSLTemplate template) throws XPathException {
        StructuredQName qName = template.getTemplateName();
        if (qName != null) {
            XSLTemplate other = this.templateIndex.get(qName);
            if (other == null) {
                this.templateIndex.put(qName, template);
                this.exec.putNamedTemplate(qName, template.getCompiledTemplate());
            } else {
                int otherPrecedence;
                int thisPrecedence = template.getPrecedence();
                if (thisPrecedence == (otherPrecedence = other.getPrecedence())) {
                    template.compileError("Duplicate named template (see line " + other.getLineNumber() + " of " + other.getSystemId() + ')', "XTSE0660");
                } else if (thisPrecedence >= otherPrecedence) {
                    this.templateIndex.put(qName, template);
                    this.exec.putNamedTemplate(qName, template.getCompiledTemplate());
                }
            }
        }
    }

    private void collectNamespaceAliases() throws XPathException {
        this.aliasSCodes = new short[this.numberOfAliases];
        this.aliasNCodes = new int[this.numberOfAliases];
        int precedenceBoundary = 0;
        int currentPrecedence = -1;
        int i = 0;
        while (i < this.numberOfAliases) {
            XSLNamespaceAlias xna = this.namespaceAliasList.get(i);
            short scode = xna.getStylesheetURICode();
            int ncode = xna.getResultNamespaceCode();
            int prec = xna.getPrecedence();
            if (currentPrecedence != prec) {
                currentPrecedence = prec;
                precedenceBoundary = i;
            }
            int j = precedenceBoundary;
            while (j < i) {
                if (scode == this.aliasSCodes[j] && (ncode & 0xFFFF) != (this.aliasNCodes[j] & 0xFFFF)) {
                    xna.compileError("More than one alias is defined for the same namespace prefix", "XTSE0810");
                }
                ++j;
            }
            this.aliasSCodes[i] = scode;
            this.aliasNCodes[i] = ncode;
            ++i;
        }
        this.namespaceAliasList = null;
    }

    protected boolean hasNamespaceAliases() {
        return this.numberOfAliases > 0;
    }

    @Override
    public void processAllAttributes() throws XPathException {
        this.processDefaultCollationAttribute("");
        this.prepareAttributes();
        if (this.topLevel == null) {
            return;
        }
        int i = 0;
        while (i < this.topLevel.size()) {
            Object s = this.topLevel.get(i);
            if (s instanceof StyleElement) {
                try {
                    ((StyleElement)s).processAllAttributes();
                }
                catch (XPathException err) {
                    ((StyleElement)s).compileError(err);
                }
            }
            ++i;
        }
    }

    public XSLVariableDeclaration getGlobalVariable(StructuredQName qName) {
        return this.globalVariableIndex.get(qName);
    }

    public void setNeedsDynamicOutputProperties(boolean b) {
        this.needsDynamicOutputProperties = b;
    }

    public Properties gatherOutputProperties(StructuredQName formatQName) throws XPathException {
        boolean found = formatQName == null;
        Properties details = new Properties(this.getConfiguration().getDefaultSerializationProperties());
        HashMap precedences = new HashMap(10);
        int i = this.topLevel.size() - 1;
        while (i >= 0) {
            Object s = this.topLevel.get(i);
            if (s instanceof XSLOutput) {
                XSLOutput xo = (XSLOutput)s;
                if (formatQName == null ? xo.getFormatQName() == null : formatQName.equals(xo.getFormatQName())) {
                    found = true;
                    xo.gatherOutputProperties(details, precedences);
                }
            }
            --i;
        }
        if (!found) {
            this.compileError("Requested output format " + formatQName.getDisplayName() + " has not been defined", "XTDE1460");
        }
        return details;
    }

    public void declareXQueryFunction(XQueryFunction function) throws XPathException {
        this.queryFunctions.declareFunction(function);
    }

    protected boolean isImportedSchema(String targetNamespace) {
        return this.schemaIndex.contains(targetNamespace);
    }

    protected void addImportedSchema(String targetNamespace) {
        this.schemaIndex.add(targetNamespace);
    }

    protected HashSet<String> getImportedSchemaTable() {
        return this.schemaIndex;
    }

    public void compileStylesheet() throws XPathException {
        block25: {
            try {
                NodeInfo node;
                PreparedStylesheet pss = this.getPreparedStylesheet();
                try {
                    Iterator<XQueryFunction> qf = this.queryFunctions.getFunctionDefinitions();
                    while (qf.hasNext()) {
                        XQueryFunction f = qf.next();
                        f.fixupReferences(this.getStaticContext());
                    }
                }
                catch (XPathException e) {
                    this.compileError(e);
                }
                int i = 0;
                while (i < this.topLevel.size()) {
                    StyleElement snode;
                    Expression inst;
                    node = (NodeInfo)this.topLevel.get(i);
                    if (node instanceof StyleElement && (inst = (snode = (StyleElement)node).compile(this.exec)) != null) {
                        inst.setLocationId(this.allocateLocationId(this.getSystemId(), snode.getLineNumber()));
                    }
                    ++i;
                }
                i = 0;
                while (i < this.topLevel.size()) {
                    node = (NodeInfo)this.topLevel.get(i);
                    if (node instanceof StylesheetProcedure) {
                        ((StylesheetProcedure)((Object)node)).optimize();
                    }
                    ++i;
                }
                if (pss.getDecimalFormatManager() != null) {
                    try {
                        pss.getDecimalFormatManager().fixupDefaultDefault();
                    }
                    catch (XPathException err) {
                        this.compileError(err.getMessage(), err.getErrorCodeQName());
                    }
                }
                this.getPrincipalStylesheet().getStripperRules().computeRankings();
                this.exec.setStripsWhitespace(this.stripsWhitespace());
                Properties props = this.gatherOutputProperties(null);
                props.setProperty("{http://saxon.sf.net/}stylesheet-version", this.getVersion().toString());
                this.exec.setDefaultOutputProperties(props);
                HashSet<StructuredQName> outputNames = new HashSet<StructuredQName>(5);
                int i2 = 0;
                while (i2 < this.topLevel.size()) {
                    XSLOutput out;
                    StructuredQName qName;
                    Object child = this.topLevel.get(i2);
                    if (child instanceof XSLOutput && (qName = (out = (XSLOutput)child).getFormatQName()) != null) {
                        outputNames.add(qName);
                    }
                    ++i2;
                }
                if (outputNames.isEmpty()) {
                    if (this.needsDynamicOutputProperties) {
                        this.compileError("The stylesheet contains xsl:result-document instructions that calculate the output format name at run-time, but there are no named xsl:output declarations", "XTDE1460");
                    }
                } else {
                    for (StructuredQName qName : outputNames) {
                        Properties oprops = this.gatherOutputProperties(qName);
                        if (!this.needsDynamicOutputProperties) continue;
                        this.exec.setOutputProperties(qName, oprops);
                    }
                }
                this.exec.setPatternSlotSpace(this.largestPatternStackFrame);
                this.exec.setStripsInputTypeAnnotations(this.inputAnnotations == 1);
                i = 0;
                while (i < this.topLevel.size()) {
                    XSLCharacterMap t;
                    if (this.topLevel.get(i) instanceof XSLCharacterMap && !(t = (XSLCharacterMap)this.topLevel.get(i)).isRedundant()) {
                        StructuredQName qn = t.getCharacterMapName();
                        IntHashMap map = new IntHashMap(20);
                        t.assemble(map);
                        if (this.exec.getCharacterMapIndex() == null) {
                            this.exec.setCharacterMapIndex(new HashMap<StructuredQName, IntHashMap<String>>(20));
                        }
                        this.exec.getCharacterMapIndex().put(qn, map);
                    }
                    ++i;
                }
                this.getRuleManager().computeRankings();
                this.getRuleManager().invertStreamableTemplates(this.getConfiguration().getOptimizer());
                ExecutableFunctionLibrary overriding = new ExecutableFunctionLibrary(this.getConfiguration());
                ExecutableFunctionLibrary underriding = new ExecutableFunctionLibrary(this.getConfiguration());
                int i3 = 0;
                while (i3 < this.topLevel.size()) {
                    Object child = this.topLevel.get(i3);
                    if (child instanceof XSLFunction) {
                        XSLFunction func = (XSLFunction)child;
                        if (func.isOverriding()) {
                            overriding.addFunction(func.getCompiledFunction());
                        } else {
                            underriding.addFunction(func.getCompiledFunction());
                        }
                    }
                    ++i3;
                }
                Configuration config = this.getConfiguration();
                FunctionLibraryList libraryList = new FunctionLibraryList();
                libraryList.addFunctionLibrary(SystemFunctionLibrary.getSystemFunctionLibrary(3));
                libraryList.addFunctionLibrary(overriding);
                libraryList.addFunctionLibrary(config.getVendorFunctionLibrary());
                libraryList.addFunctionLibrary(new ConstructorFunctionLibrary(this.getConfiguration()));
                libraryList.addFunctionLibrary(this.queryFunctions);
                libraryList.addFunctionLibrary(config.getIntegratedFunctionLibrary());
                config.addExtensionBinders(libraryList);
                libraryList.addFunctionLibrary(underriding);
                this.exec.setFunctionLibrary(libraryList);
            }
            catch (RuntimeException err) {
                if (this.getPreparedStylesheet().getErrorCount() != 0) break block25;
                throw err;
            }
        }
    }

    @Override
    public Expression compile(Executable exec) {
        return null;
    }

    public int allocateUniqueParameterNumber(StructuredQName qName) {
        Integer x;
        if (this.localParameterNumbers == null) {
            this.localParameterNumbers = new HashMap(50);
        }
        if ((x = this.localParameterNumbers.get(qName)) == null) {
            x = new Integer(this.localParameterNumbers.size());
            this.localParameterNumbers.put(qName, x);
        }
        return x;
    }
}

