/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.StringLiteral;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.instruct.SimpleContentConstructor;
import net2.sf.saxon.instruct.SimpleNodeConstructor;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.style.StyleElement;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.StringValue;

public abstract class XSLStringConstructor
extends StyleElement {
    protected Expression select = null;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void validate() throws XPathException {
        if (this.select != null && this.hasChildNodes()) {
            String errorCode = this.getErrorCodeForSelectPlusContent();
            this.compileError("An " + this.getDisplayName() + " element with a select attribute must be empty", errorCode);
        }
        AxisIterator kids = this.iterateAxis((byte)3);
        NodeInfo first = (NodeInfo)kids.next();
        if (this.select == null) {
            if (first == null) {
                this.select = new StringLiteral(StringValue.EMPTY_STRING);
            } else if (kids.next() == null && first.getNodeKind() == 3) {
                this.select = new StringLiteral(first.getStringValue());
            }
        }
    }

    protected abstract String getErrorCodeForSelectPlusContent();

    protected void compileContent(Executable exec, SimpleNodeConstructor inst, Expression separator) throws XPathException {
        if (separator == null) {
            separator = new StringLiteral(StringValue.SINGLE_SPACE);
        }
        try {
            if (this.select != null) {
                inst.setSelect(this.makeExpressionVisitor().simplify(new SimpleContentConstructor(this.select, separator)), exec.getConfiguration());
            } else {
                Expression content = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
                inst.setSelect(this.makeExpressionVisitor().simplify(new SimpleContentConstructor(content, separator)), exec.getConfiguration());
            }
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }
}

