/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.StringLiteral;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.instruct.ProcessingInstruction;
import net2.sf.saxon.om.AttributeCollection;
import net2.sf.saxon.style.XSLStringConstructor;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.Whitespace;

public class XSLProcessingInstruction
extends XSLStringConstructor {
    Expression name;

    @Override
    public void prepareAttributes() throws XPathException {
        String nameAtt = null;
        String selectAtt = null;
        AttributeCollection atts = this.getAttributeList();
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f == "name") {
                nameAtt = Whitespace.trim(atts.getValue(a));
            } else if (f == "select") {
                selectAtt = Whitespace.trim(atts.getValue(a));
            } else {
                this.checkUnknownAttribute(nc);
            }
            ++a;
        }
        if (nameAtt == null) {
            this.reportAbsence("name");
        } else {
            this.name = this.makeAttributeValueTemplate(nameAtt);
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
    }

    @Override
    public void validate() throws XPathException {
        this.name = this.typeCheck("name", this.name);
        this.select = this.typeCheck("select", this.select);
        super.validate();
    }

    @Override
    protected String getErrorCodeForSelectPlusContent() {
        return "XTSE0880";
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        ProcessingInstruction inst = new ProcessingInstruction(this.name);
        this.compileContent(exec, inst, new StringLiteral(StringValue.SINGLE_SPACE));
        return inst;
    }
}

