/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.om.AttributeCollection;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.sort.SortExpression;
import net2.sf.saxon.sort.SortKeyDefinition;
import net2.sf.saxon.style.StyleElement;
import net2.sf.saxon.style.XSLFallback;
import net2.sf.saxon.style.XSLSort;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.Whitespace;

public class XSLPerformSort
extends StyleElement {
    Expression select = null;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected ItemType getReturnedItemType() {
        if (this.select == null) {
            return this.getCommonChildItemType();
        }
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        return this.select.getItemType(th);
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLSort;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
            } else {
                this.checkUnknownAttribute(nc);
            }
            ++a;
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
    }

    @Override
    public void validate() throws XPathException {
        this.checkSortComesFirst(true);
        if (this.select != null) {
            NodeInfo child;
            AxisIterator kids = this.iterateAxis((byte)3);
            while ((child = (NodeInfo)kids.next()) != null) {
                if (child instanceof XSLSort || child instanceof XSLFallback) continue;
                if (child.getNodeKind() == 3 && !Whitespace.isWhite(child.getStringValueCS())) {
                    this.compileError("Within xsl:perform-sort, significant text must not appear if there is a select attribute", "XTSE1040");
                    continue;
                }
                ((StyleElement)child).compileError("Within xsl:perform-sort, child instructions are not allowed if there is a select attribute", "XTSE1040");
            }
        }
        this.select = this.typeCheck("select", this.select);
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        SortKeyDefinition[] sortKeys = this.makeSortKeys();
        if (this.select != null) {
            return new SortExpression(this.select, sortKeys);
        }
        Expression body = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
        if (body == null) {
            body = Literal.makeEmptySequence();
        }
        try {
            return new SortExpression(this.makeExpressionVisitor().simplify(body), sortKeys);
        }
        catch (XPathException e) {
            this.compileError(e);
            return null;
        }
    }
}

