/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import net2.sf.saxon.charcode.UTF16CharacterSet;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.om.AttributeCollection;
import net2.sf.saxon.style.StyleElement;
import net2.sf.saxon.style.XSLCharacterMap;
import net2.sf.saxon.trans.XPathException;

public class XSLOutputCharacter
extends StyleElement {
    private int codepoint = -1;
    private String replacementString = null;

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f == "character") {
                String s = atts.getValue(a);
                switch (s.length()) {
                    case 0: {
                        this.compileError("character attribute must not be zero-length", "XTSE0020");
                        this.codepoint = 256;
                        break;
                    }
                    case 1: {
                        this.codepoint = s.charAt(0);
                        break;
                    }
                    case 2: {
                        if (UTF16CharacterSet.isHighSurrogate(s.charAt(0)) && UTF16CharacterSet.isLowSurrogate(s.charAt(1))) {
                            this.codepoint = UTF16CharacterSet.combinePair(s.charAt(0), s.charAt(1));
                            break;
                        }
                        this.compileError("character attribute must be a single XML character", "XTSE0020");
                        this.codepoint = 256;
                        break;
                    }
                    default: {
                        this.compileError("character attribute must be a single XML character", "XTSE0020");
                        this.codepoint = 256;
                        break;
                    }
                }
            } else if (f == "string") {
                this.replacementString = atts.getValue(a);
            } else {
                this.checkUnknownAttribute(nc);
            }
            ++a;
        }
        if (this.codepoint == -1) {
            this.reportAbsence("character");
            return;
        }
        if (this.replacementString == null) {
            this.reportAbsence("string");
            return;
        }
    }

    @Override
    public void validate() throws XPathException {
        if (!(this.getParent() instanceof XSLCharacterMap)) {
            this.compileError("xsl:output-character may appear only as a child of xsl:character-map", "XTSE0010");
        }
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        return null;
    }

    public int getCodePoint() {
        return this.codepoint;
    }

    public String getReplacementString() {
        return this.replacementString;
    }
}

