/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.StringLiteral;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.instruct.NamespaceConstructor;
import net2.sf.saxon.om.AttributeCollection;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.style.XSLFallback;
import net2.sf.saxon.style.XSLStringConstructor;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.Whitespace;

public class XSLNamespace
extends XSLStringConstructor {
    Expression name;

    @Override
    public void prepareAttributes() throws XPathException {
        String nameAtt = null;
        String selectAtt = null;
        AttributeCollection atts = this.getAttributeList();
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f == "name") {
                nameAtt = Whitespace.trim(atts.getValue(a));
            } else if (f == "select") {
                selectAtt = Whitespace.trim(atts.getValue(a));
            } else {
                this.checkUnknownAttribute(nc);
            }
            ++a;
        }
        if (nameAtt == null) {
            this.reportAbsence("name");
        } else {
            this.name = this.makeAttributeValueTemplate(nameAtt);
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
    }

    @Override
    public void validate() throws XPathException {
        NodeInfo child;
        this.name = this.typeCheck("name", this.name);
        this.select = this.typeCheck("select", this.select);
        int countChildren = 0;
        NodeInfo firstChild = null;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (child instanceof XSLFallback) continue;
            if (this.select != null) {
                String errorCode = this.getErrorCodeForSelectPlusContent();
                this.compileError("An " + this.getDisplayName() + " element with a select attribute must be empty", errorCode);
            }
            ++countChildren;
            if (firstChild != null) break;
            firstChild = child;
        }
        if (this.select == null) {
            if (countChildren == 0) {
                this.select = new StringLiteral(StringValue.EMPTY_STRING);
            } else if (countChildren == 1 && firstChild.getNodeKind() == 3) {
                this.select = new StringLiteral(firstChild.getStringValueCS());
            }
        }
    }

    @Override
    protected String getErrorCodeForSelectPlusContent() {
        return "XTSE0910";
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        NamespaceConstructor inst = new NamespaceConstructor(this.name);
        this.compileContent(exec, inst, new StringLiteral(StringValue.SINGLE_SPACE));
        return inst;
    }
}

