/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.expr.AtomicSequenceConverter;
import net2.sf.saxon.expr.Atomizer;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.RoleLocator;
import net2.sf.saxon.expr.StaticContext;
import net2.sf.saxon.expr.TypeChecker;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.instruct.SlotManager;
import net2.sf.saxon.om.AttributeCollection;
import net2.sf.saxon.om.NamespaceException;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.pattern.Pattern;
import net2.sf.saxon.sort.CodepointCollator;
import net2.sf.saxon.sort.StringCollator;
import net2.sf.saxon.style.StyleElement;
import net2.sf.saxon.style.StylesheetProcedure;
import net2.sf.saxon.style.XSLStylesheet;
import net2.sf.saxon.trans.Err;
import net2.sf.saxon.trans.KeyDefinition;
import net2.sf.saxon.trans.KeyManager;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.SequenceType;
import net2.sf.saxon.value.Whitespace;

public class XSLKey
extends StyleElement
implements StylesheetProcedure {
    private Pattern match;
    private Expression use;
    private String collationName;
    private StructuredQName keyName;
    SlotManager stackFrameMap;

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        String nameAtt = null;
        String matchAtt = null;
        String useAtt = null;
        AttributeCollection atts = this.getAttributeList();
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("name")) {
                nameAtt = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("use")) {
                useAtt = atts.getValue(a);
            } else if (f.equals("match")) {
                matchAtt = atts.getValue(a);
            } else if (f.equals("collation")) {
                this.collationName = Whitespace.trim(atts.getValue(a));
            } else {
                this.checkUnknownAttribute(nc);
            }
            ++a;
        }
        if (nameAtt == null) {
            this.reportAbsence("name");
            return;
        }
        try {
            this.keyName = this.makeQName(nameAtt);
            this.setObjectName(this.keyName);
        }
        catch (NamespaceException err) {
            this.compileError(err.getMessage(), "XTSE0280");
        }
        catch (XPathException err) {
            this.compileError(err);
        }
        if (matchAtt == null) {
            this.reportAbsence("match");
            matchAtt = "*";
        }
        this.match = this.makePattern(matchAtt);
        if (useAtt != null) {
            this.use = this.makeExpression(useAtt);
        }
    }

    public StructuredQName getKeyName() {
        try {
            String nameAtt;
            if (this.getObjectName() == null && (nameAtt = this.getAttributeValue("", "name")) != null) {
                this.setObjectName(this.makeQName(nameAtt));
            }
            return this.getObjectName();
        }
        catch (NamespaceException err) {
            return null;
        }
        catch (XPathException err) {
            return null;
        }
    }

    @Override
    public void validate() throws XPathException {
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        this.checkTopLevel(null);
        if (this.use != null) {
            if (this.hasChildNodes()) {
                this.compileError("An xsl:key element with a @use attribute must be empty", "XTSE1205");
            }
            try {
                RoleLocator role = new RoleLocator(4, (Serializable)((Object)"xsl:key/use"), 0);
                this.use = TypeChecker.staticTypeCheck(this.use, SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, 57344), false, role, this.makeExpressionVisitor());
            }
            catch (XPathException err) {
                this.compileError(err);
            }
        } else if (!this.hasChildNodes()) {
            this.compileError("An xsl:key element must either have a @use attribute or have content", "XTSE1205");
        }
        this.use = this.typeCheck("use", this.use);
        this.match = this.typeCheck("match", this.match);
        if (this.use != null) {
            this.use = this.makeExpressionVisitor().typeCheck(this.use, this.match.getNodeTest());
        }
        if (this.collationName != null) {
            try {
                URI collationURI = new URI(this.collationName);
                if (!collationURI.isAbsolute()) {
                    URI base = new URI(this.getBaseURI());
                    collationURI = base.resolve(collationURI);
                    this.collationName = collationURI.toString();
                }
            }
            catch (URISyntaxException err) {
                this.compileError("Collation name '" + this.collationName + "' is not a valid URI");
            }
        } else {
            this.collationName = this.getDefaultCollationName();
        }
    }

    @Override
    protected void index(XSLStylesheet top) throws XPathException {
        StructuredQName keyName = this.getKeyName();
        if (keyName != null) {
            top.getExecutable().getKeyManager().preRegisterKeyDefinition(keyName);
        }
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        StaticContext env = this.getStaticContext();
        Configuration config = env.getConfiguration();
        StringCollator collator = null;
        if (this.collationName != null) {
            collator = this.getPrincipalStylesheet().findCollation(this.collationName);
            if (collator == null) {
                this.compileError("The collation name " + Err.wrap(this.collationName, 7) + " is not recognized", "XTSE1210");
                collator = CodepointCollator.getInstance();
            }
            if (collator instanceof CodepointCollator) {
                collator = null;
                this.collationName = null;
            } else if (!Configuration.getPlatform().canReturnCollationKeys(collator)) {
                this.compileError("The collation used for xsl:key must be capable of generating collation keys", "XTSE1210");
            }
        }
        if (this.use == null) {
            Expression body = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
            try {
                ExpressionVisitor visitor = this.makeExpressionVisitor();
                this.use = new Atomizer(body);
                this.use = visitor.simplify(this.use);
            }
            catch (XPathException e) {
                this.compileError(e);
            }
            try {
                RoleLocator role = new RoleLocator(4, (Serializable)((Object)"xsl:key/use"), 0);
                this.use = TypeChecker.staticTypeCheck(this.use, SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, 57344), false, role, this.makeExpressionVisitor());
                this.use = this.makeExpressionVisitor().typeCheck(this.use, this.match.getNodeTest());
            }
            catch (XPathException err) {
                this.compileError(err);
            }
        }
        TypeHierarchy th = config.getTypeHierarchy();
        BuiltInAtomicType useType = (BuiltInAtomicType)this.use.getItemType(th).getPrimitiveItemType();
        if (this.backwardsCompatibleModeIsEnabled() && !useType.equals(BuiltInAtomicType.STRING) && !useType.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            this.use = new AtomicSequenceConverter(this.use, BuiltInAtomicType.STRING);
            useType = BuiltInAtomicType.STRING;
        }
        this.allocateSlots(this.use);
        int slots = this.match.allocateSlots(this.getStaticContext(), this.stackFrameMap, 0);
        this.allocatePatternSlots(slots);
        KeyManager km = this.getPrincipalStylesheet().getKeyManager();
        KeyDefinition keydef = new KeyDefinition(this.match, this.use, this.collationName, collator);
        keydef.setIndexedItemType(useType);
        keydef.setStackFrameMap(this.stackFrameMap);
        keydef.setLocation(this.getSystemId(), this.getLineNumber());
        keydef.setExecutable(this.getExecutable());
        keydef.setBackwardsCompatible(this.backwardsCompatibleModeIsEnabled());
        try {
            km.addKeyDefinition(this.keyName, keydef, exec.getConfiguration());
        }
        catch (XPathException err) {
            this.compileError(err);
        }
        return null;
    }

    @Override
    public void optimize() throws XPathException {
    }
}

