/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.Optimizer;
import net2.sf.saxon.expr.RoleLocator;
import net2.sf.saxon.expr.TailCallLoop;
import net2.sf.saxon.expr.TypeChecker;
import net2.sf.saxon.expr.UserFunctionCall;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.instruct.SlotManager;
import net2.sf.saxon.instruct.TraceInstruction;
import net2.sf.saxon.instruct.UserFunction;
import net2.sf.saxon.instruct.UserFunctionParameter;
import net2.sf.saxon.om.AttributeCollection;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NamespaceException;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.style.StyleElement;
import net2.sf.saxon.style.StylesheetProcedure;
import net2.sf.saxon.style.XSLParam;
import net2.sf.saxon.style.XSLStylesheet;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.SequenceType;
import net2.sf.saxon.value.Whitespace;

public class XSLFunction
extends StyleElement
implements StylesheetProcedure {
    private String nameAtt = null;
    private String asAtt = null;
    private String overrideAtt = null;
    private SequenceType resultType;
    private String functionName;
    private SlotManager stackFrameMap;
    private boolean memoFunction = false;
    private boolean override = true;
    private int numberOfArguments = -1;
    private UserFunction compiledFunction;
    List references = new ArrayList(10);

    public void registerReference(UserFunctionCall ref) {
        this.references.add(ref);
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        this.overrideAtt = "yes";
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("name")) {
                this.nameAtt = Whitespace.trim(atts.getValue(a));
                if (this.nameAtt.indexOf(58) < 0) {
                    this.compileError("Function name must have a namespace prefix", "XTSE0740");
                }
                try {
                    this.setObjectName(this.makeQName(this.nameAtt));
                }
                catch (NamespaceException err) {
                    this.compileError(err.getMessage(), "XTSE0280");
                }
                catch (XPathException err) {
                    this.compileError(err);
                }
            } else if (f.equals("as")) {
                this.asAtt = atts.getValue(a);
            } else if (f.equals("override")) {
                this.overrideAtt = Whitespace.trim(atts.getValue(a));
                if (this.overrideAtt.equals("yes")) {
                    this.override = true;
                } else if (this.overrideAtt.equals("no")) {
                    this.override = false;
                } else {
                    this.override = true;
                    this.compileError("override must be 'yes' or 'no'", "XTSE0020");
                }
            } else if (f.equals("{http://saxon.sf.net/}memo-function")) {
                String memoAtt = Whitespace.trim(atts.getValue(a));
                if (memoAtt.equals("yes")) {
                    this.memoFunction = true;
                } else if (memoAtt.equals("no")) {
                    this.memoFunction = false;
                } else {
                    this.compileError("saxon:memo-function must be 'yes' or 'no'", "XTSE0020");
                }
            } else {
                this.checkUnknownAttribute(nc);
            }
            ++a;
        }
        if (this.nameAtt == null) {
            this.reportAbsence("name");
            this.nameAtt = "xsl:unnamed-function";
        }
        this.resultType = this.asAtt == null ? SequenceType.ANY_SEQUENCE : this.makeSequenceType(this.asAtt);
        this.functionName = this.nameAtt;
    }

    @Override
    public StructuredQName getObjectName() {
        StructuredQName qn = super.getObjectName();
        if (qn == null) {
            this.nameAtt = Whitespace.trim(this.getAttributeValue("", "name"));
            if (this.nameAtt == null) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-function");
            }
            try {
                qn = this.makeQName(this.nameAtt);
                this.setObjectName(qn);
            }
            catch (NamespaceException err) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-function");
            }
            catch (XPathException err) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-function");
            }
        }
        return qn;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    protected boolean mayContainParam(String attName) {
        return !"required".equals(attName);
    }

    @Override
    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLParam;
    }

    public boolean isOverriding() {
        if (this.overrideAtt == null) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return this.override;
    }

    @Override
    public void fixupReferences() throws XPathException {
        Iterator iter = this.references.iterator();
        while (iter.hasNext()) {
            ((UserFunctionCall)iter.next()).setStaticType(this.resultType);
        }
        super.fixupReferences();
    }

    @Override
    public void validate() throws XPathException {
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        this.checkTopLevel(null);
        this.getNumberOfArguments();
        XSLStylesheet root = this.getPrincipalStylesheet();
        List toplevel = root.getTopLevel();
        boolean isDuplicate = false;
        int i = toplevel.size() - 1;
        while (i >= 0) {
            Object child = toplevel.get(i);
            if (child instanceof XSLFunction && child != this && ((XSLFunction)child).getObjectName().equals(this.getObjectName()) && ((XSLFunction)child).getNumberOfArguments() == this.numberOfArguments) {
                if (((XSLFunction)child).getPrecedence() == this.getPrecedence()) {
                    isDuplicate = true;
                }
                if (((XSLFunction)child).getPrecedence() > this.getPrecedence()) {
                    isDuplicate = false;
                    break;
                }
            }
            --i;
        }
        if (isDuplicate) {
            this.compileError("Duplicate function declaration", "XTSE0770");
        }
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        this.compileAsExpression(exec);
        return null;
    }

    private void compileAsExpression(Executable exec) throws XPathException {
        Expression exp = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), false);
        if (exp == null) {
            exp = Literal.makeEmptySequence();
        }
        UserFunction fn = exec.getConfiguration().newUserFunction(this.memoFunction);
        fn.setHostLanguage(50);
        fn.setBody(exp);
        fn.setFunctionName(this.getObjectName());
        this.setParameterDefinitions(fn);
        fn.setResultType(this.getResultType());
        fn.setLineNumber(this.getLineNumber());
        fn.setSystemId(this.getSystemId());
        fn.setStackFrameMap(this.stackFrameMap);
        fn.setExecutable(exec);
        this.compiledFunction = fn;
        this.fixupInstruction(fn);
        if (this.memoFunction && !fn.isMemoFunction()) {
            this.compileWarning("Memo functions are not available in Saxon-HE: saxon:memo-function attribute ignored", "SXWN9011");
        }
    }

    @Override
    public void optimize() throws XPathException {
        int tailCalls;
        Expression exp;
        Expression exp2 = exp = this.compiledFunction.getBody();
        ExpressionVisitor visitor = this.makeExpressionVisitor();
        Optimizer opt = this.getConfiguration().getOptimizer();
        try {
            exp2 = visitor.typeCheck(exp, null);
            if (this.resultType != null) {
                RoleLocator role = new RoleLocator(5, (Serializable)((Object)this.functionName), 0);
                role.setErrorCode("XTTE0780");
                exp2 = TypeChecker.staticTypeCheck(exp2, this.resultType, false, role, visitor);
            }
            if (opt.getOptimizationLevel() != 0) {
                exp2 = exp2.optimize(visitor, null);
            }
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            this.compileError(err);
        }
        if (opt.getOptimizationLevel() != 0) {
            exp2 = opt.promoteExpressionsToGlobal(exp2, visitor, false);
        }
        if (this.getPreparedStylesheet().isCompileWithTracing()) {
            TraceInstruction trace = new TraceInstruction(exp2, this);
            trace.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            exp2 = trace;
        }
        this.allocateSlots(exp2);
        if (exp2 != exp) {
            this.compiledFunction.setBody(exp2);
        }
        if ((tailCalls = ExpressionTool.markTailFunctionCalls(exp2, this.getObjectName(), this.getNumberOfArguments())) != 0) {
            this.compiledFunction.setTailRecursive(tailCalls > 0, tailCalls > 1);
            this.compiledFunction.setBody(new TailCallLoop(this.compiledFunction));
        }
        this.compiledFunction.computeEvaluationMode();
        if (this.isExplaining()) {
            exp2.explain(System.err);
        }
    }

    private void fixupInstruction(UserFunction compiledFunction) throws XPathException {
        ExpressionVisitor visitor = this.makeExpressionVisitor();
        try {
            for (UserFunctionCall call : this.references) {
                call.setFunction(compiledFunction);
                call.checkFunctionCall(compiledFunction, visitor);
                call.computeArgumentEvaluationModes();
            }
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    @Override
    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public SequenceType getResultType() {
        return this.resultType;
    }

    public int getNumberOfArguments() {
        if (this.numberOfArguments == -1) {
            Item child;
            this.numberOfArguments = 0;
            AxisIterator kids = this.iterateAxis((byte)3);
            while ((child = kids.next()) instanceof XSLParam) {
                ++this.numberOfArguments;
            }
            return this.numberOfArguments;
        }
        return this.numberOfArguments;
    }

    public void setParameterDefinitions(UserFunction fn) {
        UserFunctionParameter[] params = new UserFunctionParameter[this.getNumberOfArguments()];
        fn.setParameterDefinitions(params);
        int count = 0;
        AxisIterator kids = this.iterateAxis((byte)3);
        NodeInfo node;
        while ((node = (NodeInfo)kids.next()) != null) {
            if (!(node instanceof XSLParam)) continue;
            UserFunctionParameter param = new UserFunctionParameter();
            params[count++] = param;
            param.setRequiredType(((XSLParam)node).getRequiredType());
            param.setVariableQName(((XSLParam)node).getVariableQName());
            param.setSlotNumber(((XSLParam)node).getSlotNumber());
            ((XSLParam)node).fixupBinding(param);
            int refs = ExpressionTool.getReferenceCount(fn.getBody(), param, false);
            param.setReferenceCount(refs);
        }
        return;
    }

    public UserFunction getCompiledFunction() {
        return this.compiledFunction;
    }

    @Override
    public int getConstructType() {
        return 149;
    }
}

