/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.instruct.ForEach;
import net2.sf.saxon.om.AttributeCollection;
import net2.sf.saxon.sort.SortExpression;
import net2.sf.saxon.sort.SortKeyDefinition;
import net2.sf.saxon.style.StyleElement;
import net2.sf.saxon.style.XSLSort;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.value.Cardinality;

public class XSLForEach
extends StyleElement {
    Expression select = null;
    boolean containsTailCall = false;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLSort;
    }

    @Override
    protected ItemType getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    @Override
    protected boolean markTailCalls() {
        if (Cardinality.allowsMany(this.select.getCardinality())) {
            return false;
        }
        StyleElement last = this.getLastChildInstruction();
        this.containsTailCall = last != null && last.markTailCalls();
        return this.containsTailCall;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
            } else {
                this.checkUnknownAttribute(nc);
            }
            ++a;
        }
        if (selectAtt == null) {
            this.reportAbsence("select");
        } else {
            this.select = this.makeExpression(selectAtt);
        }
    }

    @Override
    public void validate() throws XPathException {
        this.checkSortComesFirst(false);
        this.select = this.typeCheck("select", this.select);
        if (!this.hasChildNodes()) {
            this.compileWarning("An empty xsl:for-each instruction has no effect", "SXWN9009");
        }
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        Expression block;
        SortKeyDefinition[] sortKeys = this.makeSortKeys();
        Expression sortedSequence = this.select;
        if (sortKeys != null) {
            sortedSequence = new SortExpression(this.select, sortKeys);
        }
        if ((block = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true)) == null) {
            return Literal.makeEmptySequence();
        }
        try {
            return new ForEach(sortedSequence, this.makeExpressionVisitor().simplify(block), this.containsTailCall);
        }
        catch (XPathException err) {
            this.compileError(err);
            return null;
        }
    }
}

