/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.StringLiteral;
import net2.sf.saxon.instruct.AttributeSet;
import net2.sf.saxon.instruct.Block;
import net2.sf.saxon.instruct.ComputedElement;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.instruct.FixedElement;
import net2.sf.saxon.instruct.SavedNamespaceContext;
import net2.sf.saxon.instruct.UseAttributeSets;
import net2.sf.saxon.om.AttributeCollection;
import net2.sf.saxon.om.QNameException;
import net2.sf.saxon.om.Validation;
import net2.sf.saxon.style.StyleElement;
import net2.sf.saxon.trans.Err;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.SchemaType;
import net2.sf.saxon.value.AnyURIValue;
import net2.sf.saxon.value.EmptySequence;
import net2.sf.saxon.value.Whitespace;

public class XSLElement
extends StyleElement {
    private Expression elementName;
    private Expression namespace = null;
    private String use;
    private AttributeSet[] attributeSets = null;
    private int validation;
    private SchemaType schemaType = null;
    private boolean inheritNamespaces = true;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String nameAtt = null;
        String namespaceAtt = null;
        String validationAtt = null;
        String typeAtt = null;
        String inheritAtt = null;
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("name")) {
                nameAtt = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("namespace")) {
                namespaceAtt = atts.getValue(a);
            } else if (f.equals("validation")) {
                validationAtt = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("type")) {
                typeAtt = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("inherit-namespaces")) {
                inheritAtt = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("use-attribute-sets")) {
                this.use = atts.getValue(a);
            } else {
                this.checkUnknownAttribute(nc);
            }
            ++a;
        }
        if (nameAtt == null) {
            this.reportAbsence("name");
        } else {
            this.elementName = this.makeAttributeValueTemplate(nameAtt);
            if (this.elementName instanceof StringLiteral && !this.getConfiguration().getNameChecker().isQName(((StringLiteral)this.elementName).getStringValue())) {
                this.compileError("Element name " + Err.wrap(((StringLiteral)this.elementName).getStringValue(), 1) + " is not a valid QName", "XTDE0820");
                this.elementName = new StringLiteral("saxon-error-element");
            }
        }
        if (namespaceAtt != null) {
            this.namespace = this.makeAttributeValueTemplate(namespaceAtt);
            if (this.namespace instanceof StringLiteral && !AnyURIValue.isValidURI(((StringLiteral)this.namespace).getStringValue())) {
                this.compileError("The value of the namespace attribute must be a valid URI", "XTDE0835");
            }
        }
        if (validationAtt != null) {
            this.validation = Validation.getCode(validationAtt);
            if (this.validation != 4 && !this.getExecutable().isSchemaAware()) {
                this.validation = 4;
                this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
            }
            if (this.validation == -1) {
                this.compileError("Invalid value for @validation attribute. Permitted values are (strict, lax, preserve, strip)", "XTSE0020");
            }
        } else {
            this.validation = this.getContainingStylesheet().getDefaultValidation();
        }
        if (typeAtt != null) {
            if (!this.getExecutable().isSchemaAware()) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.schemaType = this.getSchemaType(typeAtt);
            this.validation = 8;
        }
        if (typeAtt != null && validationAtt != null) {
            this.compileError("The @validation and @type attributes are mutually exclusive", "XTSE1505");
        }
        if (inheritAtt != null) {
            if (inheritAtt.equals("yes")) {
                this.inheritNamespaces = true;
            } else if (inheritAtt.equals("no")) {
                this.inheritNamespaces = false;
            } else {
                this.compileError("The @inherit-namespaces attribute has permitted values (yes, no)", "XTSE0020");
            }
        }
    }

    @Override
    public void validate() throws XPathException {
        if (this.use != null) {
            this.attributeSets = this.getAttributeSets(this.use, null);
        }
        this.elementName = this.typeCheck("name", this.elementName);
        this.namespace = this.typeCheck("namespace", this.namespace);
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        SavedNamespaceContext nsContext = null;
        if (this.elementName instanceof StringLiteral) {
            String[] parts;
            String qName = ((StringLiteral)this.elementName).getStringValue();
            try {
                parts = this.getConfiguration().getNameChecker().getQNameParts(qName);
            }
            catch (QNameException e) {
                this.compileError("Invalid element name: " + qName, "XTDE0820");
                return null;
            }
            String nsuri = null;
            if (this.namespace instanceof StringLiteral) {
                nsuri = ((StringLiteral)this.namespace).getStringValue();
                if (nsuri.length() == 0) {
                    parts[0] = "";
                }
            } else if (this.namespace == null && (nsuri = this.getURIForPrefix(parts[0], true)) == null) {
                this.undeclaredNamespaceError(parts[0], "XTDE0830");
            }
            if (nsuri != null) {
                int nameCode = this.getNamePool().allocate(parts[0], nsuri, parts[1]);
                FixedElement inst = new FixedElement(nameCode, null, this.inheritNamespaces, this.schemaType, this.validation);
                inst.setBaseURI(this.getBaseURI());
                Expression content = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
                if (this.attributeSets != null) {
                    UseAttributeSets use = new UseAttributeSets(this.attributeSets);
                    if (content == null) {
                        content = use;
                    } else {
                        content = Block.makeBlock(use, content);
                        content.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                    }
                }
                if (content == null) {
                    content = new Literal(EmptySequence.getInstance());
                }
                inst.setContentExpression(content);
                return inst;
            }
        } else if (this.namespace == null) {
            nsContext = this.makeNamespaceContext();
        }
        ComputedElement inst = new ComputedElement(this.elementName, this.namespace, nsContext, this.schemaType, this.validation, this.inheritNamespaces, false);
        Expression content = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
        if (this.attributeSets != null) {
            UseAttributeSets use = new UseAttributeSets(this.attributeSets);
            if (content == null) {
                content = use;
            } else {
                content = Block.makeBlock(use, content);
                content.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            }
        }
        if (content == null) {
            content = new Literal(EmptySequence.getInstance());
        }
        inst.setContentExpression(content);
        return inst;
    }
}

