/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import net2.sf.saxon.expr.ContextItemExpression;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.InstanceOfExpression;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.instruct.AttributeSet;
import net2.sf.saxon.instruct.Block;
import net2.sf.saxon.instruct.Choose;
import net2.sf.saxon.instruct.Copy;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.instruct.UseAttributeSets;
import net2.sf.saxon.om.AttributeCollection;
import net2.sf.saxon.om.Validation;
import net2.sf.saxon.pattern.NodeKindTest;
import net2.sf.saxon.style.StyleElement;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.SchemaType;
import net2.sf.saxon.value.SequenceType;
import net2.sf.saxon.value.Whitespace;

public class XSLCopy
extends StyleElement {
    private String use;
    private AttributeSet[] attributeSets = null;
    private boolean copyNamespaces = true;
    private boolean inheritNamespaces = true;
    private int validationAction = 3;
    private SchemaType schemaType = null;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String copyNamespacesAtt = null;
        String validationAtt = null;
        String typeAtt = null;
        String inheritAtt = null;
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("use-attribute-sets")) {
                this.use = atts.getValue(a);
            } else if (f.equals("copy-namespaces")) {
                copyNamespacesAtt = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("type")) {
                typeAtt = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("validation")) {
                validationAtt = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("inherit-namespaces")) {
                inheritAtt = Whitespace.trim(atts.getValue(a));
            } else {
                this.checkUnknownAttribute(nc);
            }
            ++a;
        }
        if (copyNamespacesAtt == null) {
            this.copyNamespaces = true;
        } else if (copyNamespacesAtt.equals("yes")) {
            this.copyNamespaces = true;
        } else if (copyNamespacesAtt.equals("no")) {
            this.copyNamespaces = false;
        } else {
            this.compileError("Value of copy-namespaces must be 'yes' or 'no'", "XTSE0020");
        }
        if (typeAtt != null && validationAtt != null) {
            this.compileError("The type and validation attributes must not both be specified", "XTSE1505");
        }
        if (validationAtt != null) {
            this.validationAction = Validation.getCode(validationAtt);
            if (this.validationAction != 4 && !this.getExecutable().isSchemaAware()) {
                this.validationAction = 4;
                this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
            }
        } else {
            this.validationAction = this.getContainingStylesheet().getDefaultValidation();
        }
        if (typeAtt != null) {
            this.schemaType = this.getSchemaType(typeAtt);
            if (!this.getExecutable().isSchemaAware()) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.validationAction = 8;
        }
        if (inheritAtt != null) {
            if (inheritAtt.equals("yes")) {
                this.inheritNamespaces = true;
            } else if (inheritAtt.equals("no")) {
                this.inheritNamespaces = false;
            } else {
                this.compileError("The @inherit-namespaces attribute has permitted values (yes, no)", "XTSE0020");
            }
        }
    }

    @Override
    public void validate() throws XPathException {
        if (this.use != null) {
            this.attributeSets = this.getAttributeSets(this.use, null);
        }
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        Copy inst = new Copy(this.copyNamespaces, this.inheritNamespaces, this.schemaType, this.validationAction);
        Expression content = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
        if (this.attributeSets != null) {
            UseAttributeSets use = new UseAttributeSets(this.attributeSets);
            InstanceOfExpression condition = new InstanceOfExpression(new ContextItemExpression(), SequenceType.makeSequenceType(NodeKindTest.ELEMENT, 16384));
            Expression choice = Choose.makeConditional(condition, use);
            if (content == null) {
                content = choice;
            } else {
                content = Block.makeBlock(choice, content);
                content.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            }
        }
        if (content == null) {
            content = Literal.makeEmptySequence();
        }
        inst.setContentExpression(content);
        return inst;
    }
}

