/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.instruct.Choose;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.instruct.TraceWrapper;
import net2.sf.saxon.om.AttributeCollection;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.style.StyleElement;
import net2.sf.saxon.style.XSLOtherwise;
import net2.sf.saxon.style.XSLWhen;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.value.BooleanValue;

public class XSLChoose
extends StyleElement {
    private StyleElement otherwise;
    private int numberOfWhens = 0;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected ItemType getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            this.checkUnknownAttribute(nc);
            ++a;
        }
    }

    @Override
    public void validate() throws XPathException {
        NodeInfo curr;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((curr = (NodeInfo)kids.next()) != null) {
            if (curr instanceof XSLWhen) {
                if (this.otherwise != null) {
                    this.otherwise.compileError("xsl:otherwise must come last", "XTSE0010");
                }
                ++this.numberOfWhens;
                continue;
            }
            if (curr instanceof XSLOtherwise) {
                if (this.otherwise != null) {
                    ((XSLOtherwise)curr).compileError("Only one xsl:otherwise is allowed in an xsl:choose", "XTSE0010");
                    continue;
                }
                this.otherwise = (StyleElement)curr;
                continue;
            }
            if (curr instanceof StyleElement) {
                ((StyleElement)curr).compileError("Only xsl:when and xsl:otherwise are allowed here", "XTSE0010");
                continue;
            }
            this.compileError("Only xsl:when and xsl:otherwise are allowed within xsl:choose", "XTSE0010");
        }
        if (this.numberOfWhens == 0) {
            this.compileError("xsl:choose must contain at least one xsl:when", "XTSE0010");
        }
    }

    @Override
    public boolean markTailCalls() {
        boolean found = false;
        AxisIterator kids = this.iterateAxis((byte)3);
        NodeInfo curr;
        while ((curr = (NodeInfo)kids.next()) != null) {
            if (!(curr instanceof StyleElement)) continue;
            found |= ((StyleElement)curr).markTailCalls();
        }
        return found;
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        NodeInfo curr;
        int entries = this.numberOfWhens + (this.otherwise == null ? 0 : 1);
        Expression[] conditions = new Expression[entries];
        Expression[] actions = new Expression[entries];
        int w = 0;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((curr = (NodeInfo)kids.next()) != null) {
            TraceWrapper trace;
            Expression b;
            if (curr instanceof XSLWhen) {
                conditions[w] = ((XSLWhen)curr).getCondition();
                b = ((XSLWhen)curr).compileSequenceConstructor(exec, curr.iterateAxis((byte)3), true);
                if (b == null) {
                    b = Literal.makeEmptySequence();
                }
                try {
                    actions[w] = b = this.makeExpressionVisitor().simplify(b);
                }
                catch (XPathException e) {
                    this.compileError(e);
                }
                if (this.getPreparedStylesheet().isCompileWithTracing()) {
                    trace = XSLChoose.makeTraceInstruction((XSLWhen)curr, actions[w]);
                    actions[w] = trace;
                }
                if (conditions[w] instanceof Literal && ((Literal)conditions[w]).getValue() instanceof BooleanValue) {
                    if (((BooleanValue)((Literal)conditions[w]).getValue()).getBooleanValue()) {
                        entries = w + 1;
                        break;
                    }
                    --w;
                    --entries;
                }
                ++w;
                continue;
            }
            if (curr instanceof XSLOtherwise) {
                conditions[w] = Literal.makeLiteral(BooleanValue.TRUE);
                b = ((XSLOtherwise)curr).compileSequenceConstructor(exec, curr.iterateAxis((byte)3), true);
                if (b == null) {
                    b = Literal.makeEmptySequence();
                }
                try {
                    actions[w] = b = this.makeExpressionVisitor().simplify(b);
                }
                catch (XPathException e) {
                    this.compileError(e);
                }
                if (this.getPreparedStylesheet().isCompileWithTracing()) {
                    trace = XSLChoose.makeTraceInstruction((XSLOtherwise)curr, actions[w]);
                    actions[w] = trace;
                }
                ++w;
                continue;
            }
            new AssertionError((Object)"Expected xsl:when or xsl:otherwise");
        }
        if (conditions.length != entries) {
            if (entries == 0) {
                return null;
            }
            if (entries == 1 && conditions[0] instanceof Literal && ((Literal)conditions[0]).getValue() instanceof BooleanValue) {
                if (((BooleanValue)((Literal)conditions[0]).getValue()).getBooleanValue()) {
                    return actions[0];
                }
                return null;
            }
            Expression[] conditions2 = new Expression[entries];
            System.arraycopy(conditions, 0, conditions2, 0, entries);
            Expression[] actions2 = new Expression[entries];
            System.arraycopy(actions, 0, actions2, 0, entries);
            conditions = conditions2;
            actions = actions2;
        }
        return new Choose(conditions, actions);
    }
}

