/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.instruct.AttributeSet;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.instruct.SlotManager;
import net2.sf.saxon.instruct.TraceInstruction;
import net2.sf.saxon.om.AttributeCollection;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NamespaceException;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.style.StyleElement;
import net2.sf.saxon.style.StylesheetProcedure;
import net2.sf.saxon.style.XSLAttribute;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.AnyItemType;
import net2.sf.saxon.value.Whitespace;

public class XSLAttributeSet
extends StyleElement
implements StylesheetProcedure {
    private String nameAtt;
    private String useAtt;
    private SlotManager stackFrameMap;
    private List attributeSetElements = null;
    private AttributeSet[] useAttributeSets = null;
    private AttributeSet procedure = new AttributeSet();
    private int referenceCount = 0;
    private boolean validated = false;

    public StructuredQName getAttributeSetName() {
        return this.getObjectName();
    }

    public AttributeSet getInstruction() {
        return this.procedure;
    }

    public void incrementReferenceCount() {
        ++this.referenceCount;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        this.useAtt = null;
        AttributeCollection atts = this.getAttributeList();
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("name")) {
                this.nameAtt = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("use-attribute-sets")) {
                this.useAtt = atts.getValue(a);
            } else {
                this.checkUnknownAttribute(nc);
            }
            ++a;
        }
        if (this.nameAtt == null) {
            this.reportAbsence("name");
            this.setObjectName(new StructuredQName("", "", "attribute-set-error-name"));
            return;
        }
        try {
            this.setObjectName(this.makeQName(this.nameAtt));
        }
        catch (NamespaceException err) {
            this.compileError(err.getMessage(), "XTSE0280");
            this.setObjectName(new StructuredQName("", "", "attribute-set-error-name"));
        }
        catch (XPathException err) {
            this.compileError(err.getMessage(), err.getErrorCodeQName());
            this.setObjectName(new StructuredQName("", "", "attribute-set-error-name"));
        }
    }

    @Override
    public void validate() throws XPathException {
        Item child;
        if (this.validated) {
            return;
        }
        this.checkTopLevel(null);
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = kids.next()) != null) {
            if (child instanceof XSLAttribute) continue;
            this.compileError("Only xsl:attribute is allowed within xsl:attribute-set", "XTSE0010");
        }
        if (this.useAtt != null) {
            this.attributeSetElements = new ArrayList(5);
            this.useAttributeSets = this.getAttributeSets(this.useAtt, this.attributeSetElements);
            Iterator it = this.attributeSetElements.iterator();
            while (it.hasNext()) {
                ((XSLAttributeSet)it.next()).checkCircularity(this);
            }
        }
        this.validated = true;
    }

    public void checkCircularity(XSLAttributeSet origin) throws XPathException {
        if (this == origin) {
            this.compileError("The definition of the attribute set is circular", "XTSE0720");
            this.useAttributeSets = null;
        } else {
            if (!this.validated) {
                return;
            }
            if (this.attributeSetElements != null) {
                Iterator it = this.attributeSetElements.iterator();
                while (it.hasNext()) {
                    ((XSLAttributeSet)it.next()).checkCircularity(origin);
                }
            }
        }
    }

    @Override
    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        if (this.referenceCount > 0) {
            Expression body = this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
            if (body == null) {
                body = Literal.makeEmptySequence();
            }
            try {
                ExpressionVisitor visitor = this.makeExpressionVisitor();
                body = visitor.simplify(body);
                if (this.getConfiguration().isCompileWithTracing()) {
                    TraceInstruction trace = new TraceInstruction(body, this);
                    trace.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
                    trace.setContainer(this.procedure);
                    body = trace;
                }
                this.procedure.setUseAttributeSets(this.useAttributeSets);
                this.procedure.setName(this.getObjectName());
                this.procedure.setBody(body);
                this.procedure.setSystemId(this.getSystemId());
                this.procedure.setLineNumber(this.getLineNumber());
                this.procedure.setExecutable(exec);
                Expression exp2 = body.optimize(visitor, AnyItemType.getInstance());
                if (body != exp2) {
                    this.procedure.setBody(exp2);
                    body = exp2;
                }
                super.allocateSlots(body);
                this.procedure.setStackFrameMap(this.stackFrameMap);
            }
            catch (XPathException e) {
                this.compileError(e);
            }
        }
        return null;
    }

    @Override
    public void optimize() throws XPathException {
    }

    @Override
    public int getConstructType() {
        return 132;
    }
}

