/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.style;

import java.io.Serializable;
import net2.sf.saxon.expr.AxisExpression;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.RoleLocator;
import net2.sf.saxon.expr.TypeChecker;
import net2.sf.saxon.instruct.ApplyTemplates;
import net2.sf.saxon.instruct.Executable;
import net2.sf.saxon.om.AttributeCollection;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.NamespaceException;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.sort.SortExpression;
import net2.sf.saxon.sort.SortKeyDefinition;
import net2.sf.saxon.style.StyleElement;
import net2.sf.saxon.style.XSLSort;
import net2.sf.saxon.style.XSLWithParam;
import net2.sf.saxon.trans.Err;
import net2.sf.saxon.trans.Mode;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.SequenceType;
import net2.sf.saxon.value.Whitespace;

public class XSLApplyTemplates
extends StyleElement {
    private Expression select;
    private StructuredQName modeName;
    private boolean useCurrentMode = false;
    private boolean useTailRecursion = false;
    private Mode mode;
    private String modeAttribute;
    private boolean implicitSelect = false;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("mode")) {
                this.modeAttribute = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("select")) {
                selectAtt = atts.getValue(a);
            } else {
                this.checkUnknownAttribute(nc);
            }
            ++a;
        }
        if (this.modeAttribute != null) {
            if (this.modeAttribute.equals("#current")) {
                this.useCurrentMode = true;
            } else if (!this.modeAttribute.equals("#default")) {
                try {
                    this.modeName = this.makeQName(this.modeAttribute);
                }
                catch (NamespaceException err) {
                    this.compileError(err.getMessage(), "XTSE0280");
                    this.modeName = null;
                }
                catch (XPathException err) {
                    this.compileError("Mode name " + Err.wrap(this.modeAttribute) + " is not a valid QName", err.getErrorCodeQName());
                    this.modeName = null;
                }
            }
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
    }

    @Override
    public void validate() throws XPathException {
        NodeInfo child;
        if (!this.useCurrentMode) {
            this.mode = this.getPrincipalStylesheet().getRuleManager().getMode(this.modeName, true);
        }
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((child = (NodeInfo)kids.next()) != null) {
            if (child instanceof XSLSort || child instanceof XSLWithParam) continue;
            if (child.getNodeKind() == 3) {
                if (Whitespace.isWhite(child.getStringValueCS())) continue;
                this.compileError("No character data is allowed within xsl:apply-templates", "XTSE0010");
                continue;
            }
            this.compileError("Invalid element within xsl:apply-templates", "XTSE0010");
        }
        if (this.select == null) {
            this.select = new AxisExpression(3, null);
            this.implicitSelect = true;
        }
        this.select = this.typeCheck("select", this.select);
        try {
            RoleLocator role = new RoleLocator(4, (Serializable)((Object)"xsl:apply-templates/select"), 0);
            role.setErrorCode("XTTE0520");
            this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.NODE_SEQUENCE, false, role, this.makeExpressionVisitor());
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    @Override
    public boolean markTailCalls() {
        this.useTailRecursion = true;
        return true;
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        SortKeyDefinition[] sortKeys = this.makeSortKeys();
        if (sortKeys != null) {
            this.useTailRecursion = false;
        }
        Expression sortedSequence = this.select;
        if (sortKeys != null) {
            sortedSequence = new SortExpression(this.select, sortKeys);
        }
        this.compileSequenceConstructor(exec, this.iterateAxis((byte)3), true);
        ApplyTemplates app = new ApplyTemplates(sortedSequence, this.useCurrentMode, this.useTailRecursion, this.mode, this.implicitSelect);
        app.setActualParameters(this.getWithParamInstructions(exec, false, app), this.getWithParamInstructions(exec, true, app));
        return app;
    }
}

